/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.matcher;

import com.google.common.collect.Sets;
import java.util.Set;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;

public class AdditionalLibraryIgnoresMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private static final Set<String> INSTRUMENTED_SPRING_BOOT_CLASSES = Sets.newHashSet((Object[])new String[]{"org.springframework.boot.autoconfigure.BackgroundPreinitializer$", "org.springframework.boot.autoconfigure.condition.OnClassCondition$", "org.springframework.boot.web.embedded.netty.NettyWebServer$", "org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer$", "org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedWebappClassLoader", "org.springframework.boot.context.embedded.EmbeddedWebApplicationContext", "org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext", "org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext", "org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext", "org.springframework.boot.web.embedded.tomcat.TomcatWebServer$", "org.springframework.boot.web.embedded.tomcat.TomcatEmbeddedWebappClassLoader", "org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean$"});

    public static <T extends TypeDescription> ElementMatcher.Junction<T> additionalLibraryIgnoresMatcher() {
        return new AdditionalLibraryIgnoresMatcher<T>();
    }

    public boolean matches(T target) {
        String name = target.getActualName();
        if (name.startsWith("com.beust.jcommander.") || name.startsWith("com.fasterxml.classmate.") || name.startsWith("com.github.mustachejava.") || name.startsWith("com.jayway.jsonpath.") || name.startsWith("com.lightbend.lagom.") || name.startsWith("javax.el.") || name.startsWith("org.apache.lucene.") || name.startsWith("org.apache.tartarus.") || name.startsWith("org.json.simple.") || name.startsWith("org.yaml.snakeyaml.")) {
            return true;
        }
        if (name.startsWith("net.sf.cglib.")) {
            return !name.equals("net.sf.cglib.core.internal.LoadingCache$2");
        }
        if (name.startsWith("org.springframework.")) {
            if (name.startsWith("org.springframework.aop.") || name.startsWith("org.springframework.cache.") || name.startsWith("org.springframework.dao.") || name.startsWith("org.springframework.ejb.") || name.startsWith("org.springframework.expression.") || name.startsWith("org.springframework.format.") || name.startsWith("org.springframework.jca.") || name.startsWith("org.springframework.jdbc.") || name.startsWith("org.springframework.jmx.") || name.startsWith("org.springframework.jndi.") || name.startsWith("org.springframework.lang.") || name.startsWith("org.springframework.messaging.") || name.startsWith("org.springframework.objenesis.") || name.startsWith("org.springframework.orm.") || name.startsWith("org.springframework.remoting.") || name.startsWith("org.springframework.scripting.") || name.startsWith("org.springframework.stereotype.") || name.startsWith("org.springframework.transaction.") || name.startsWith("org.springframework.ui.") || name.startsWith("org.springframework.validation.")) {
                return true;
            }
            if (name.startsWith("org.springframework.data.")) {
                return !name.equals("org.springframework.data.repository.core.support.RepositoryFactorySupport") && !name.startsWith("org.springframework.data.convert.ClassGeneratingEntityInstantiator$") && !name.equals("org.springframework.data.jpa.repository.config.InspectionClassLoader");
            }
            if (name.startsWith("org.springframework.amqp.")) {
                return !name.startsWith("org.springframework.amqp.rabbit.connection.");
            }
            if (name.startsWith("org.springframework.beans.")) {
                return !name.equals("org.springframework.beans.factory.support.DisposableBeanAdapter") && !name.startsWith("org.springframework.beans.factory.groovy.GroovyBeanDefinitionReader$");
            }
            if (name.startsWith("org.springframework.boot.")) {
                return !AdditionalLibraryIgnoresMatcher.instrumentedSpringBootClasses(name) && !name.startsWith("org.springframework.boot.web.filter.") && !name.startsWith("org.springframework.boot.web.servlet.");
            }
            if (name.startsWith("org.springframework.cglib.")) {
                return !name.startsWith("org.springframework.cglib.core.internal.LoadingCache$");
            }
            if (name.startsWith("org.springframework.context.")) {
                return !name.startsWith("org.springframework.context.support.AbstractApplicationContext$") && !name.equals("org.springframework.context.support.ContextTypeMatchClassLoader");
            }
            if (name.startsWith("org.springframework.core.")) {
                return !name.startsWith("org.springframework.core.task.") && !name.equals("org.springframework.core.DecoratingClassLoader") && !name.equals("org.springframework.core.OverridingClassLoader") && !name.equals("org.springframework.core.ReactiveAdapterRegistry$EmptyCompletableFuture");
            }
            if (name.startsWith("org.springframework.instrument.")) {
                return !name.equals("org.springframework.instrument.classloading.SimpleThrowawayClassLoader") && !name.equals("org.springframework.instrument.classloading.ShadowingClassLoader");
            }
            if (name.startsWith("org.springframework.http.")) {
                return !name.startsWith("org.springframework.http.server.reactive.");
            }
            if (name.startsWith("org.springframework.jms.")) {
                return !name.startsWith("org.springframework.jms.listener.") && !name.equals("org.springframework.jms.config.JmsListenerEndpointRegistry$AggregatingCallback");
            }
            if (name.startsWith("org.springframework.util.")) {
                return !name.startsWith("org.springframework.util.concurrent.");
            }
            if (name.startsWith("org.springframework.web.")) {
                return !name.startsWith("org.springframework.web.servlet.") && !name.startsWith("org.springframework.web.filter.") && !name.startsWith("org.springframework.web.reactive.") && !name.startsWith("org.springframework.web.context.request.async.") && !name.equals("org.springframework.web.context.support.AbstractRefreshableWebApplicationContext") && !name.equals("org.springframework.web.context.support.GenericWebApplicationContext") && !name.equals("org.springframework.web.context.support.XmlWebApplicationContext");
            }
            return false;
        }
        if (name.startsWith("javax.xml.") && !name.startsWith("javax.xml.ws.") || name.startsWith("org.apache.bcel.") || name.startsWith("org.apache.html.") || name.startsWith("org.apache.regexp.") || name.startsWith("org.apache.wml.") || name.startsWith("org.apache.xalan.") || name.startsWith("org.apache.xerces.") || name.startsWith("org.apache.xml.") || name.startsWith("org.apache.xpath.") || name.startsWith("org.xml.")) {
            return true;
        }
        if (name.startsWith("ch.qos.logback.")) {
            if (name.equals("ch.qos.logback.core.AsyncAppenderBase$Worker")) {
                return false;
            }
            return !name.equals("ch.qos.logback.classic.Logger") && !name.equals("ch.qos.logback.classic.spi.LoggingEvent") && !name.equals("ch.qos.logback.classic.spi.LoggingEventVO");
        }
        if (name.startsWith("com.codahale.metrics.")) {
            return !name.startsWith("com.codahale.metrics.servlets.");
        }
        if (name.startsWith("com.couchbase.client.deps.")) {
            return !name.startsWith("com.couchbase.client.deps.io.netty.") && !name.startsWith("com.couchbase.client.deps.org.LatencyUtils.") && !name.startsWith("com.couchbase.client.deps.com.lmax.disruptor.");
        }
        if (name.startsWith("com.google.cloud.") || name.startsWith("com.google.instrumentation.") || name.startsWith("com.google.j2objc.") || name.startsWith("com.google.gson.") || name.startsWith("com.google.logging.") || name.startsWith("com.google.longrunning.") || name.startsWith("com.google.protobuf.") || name.startsWith("com.google.rpc.") || name.startsWith("com.google.thirdparty.") || name.startsWith("com.google.type.")) {
            return true;
        }
        if (name.startsWith("com.google.common.")) {
            return !name.startsWith("com.google.common.util.concurrent.") && !name.equals("com.google.common.base.internal.Finalizer");
        }
        if (name.startsWith("com.google.inject.")) {
            if (name.startsWith("com.google.inject.internal.AbstractBindingProcessor$") || name.startsWith("com.google.inject.internal.BytecodeGen$") || name.startsWith("com.google.inject.internal.cglib.core.internal.$LoadingCache$")) {
                return false;
            }
            return !name.startsWith("com.google.inject.internal.cglib.core.internal.$LoadingCache$");
        }
        if (name.startsWith("com.google.api.")) {
            return !name.startsWith("com.google.api.client.http.HttpRequest");
        }
        if (name.startsWith("org.h2.")) {
            return !name.equals("org.h2.Driver") && !name.startsWith("org.h2.jdbc.") && !name.startsWith("org.h2.jdbcx.") && !name.equals("org.h2.util.Task") && !name.equals("org.h2.store.FileLock") && !name.equals("org.h2.engine.DatabaseCloser") && !name.equals("org.h2.engine.OnExitDatabaseCloser");
        }
        if (name.startsWith("com.carrotsearch.hppc.")) {
            return !name.startsWith("com.carrotsearch.hppc.HashOrderMixing$");
        }
        if (name.startsWith("com.fasterxml.jackson.")) {
            return !name.equals("com.fasterxml.jackson.module.afterburner.util.MyClassLoader");
        }
        if (name.startsWith("kotlin.")) {
            return !name.equals("kotlin.coroutines.jvm.internal.DebugProbesKt");
        }
        return false;
    }

    private static String outerClassName(String name) {
        int separator = name.indexOf(36);
        return separator == -1 ? name : name.substring(0, separator + 1);
    }

    private static boolean instrumentedSpringBootClasses(String name) {
        String outerName = AdditionalLibraryIgnoresMatcher.outerClassName(name);
        return INSTRUMENTED_SPRING_BOOT_CLASSES.contains(outerName);
    }

    public String toString() {
        return "additionalLibraryIgnoresMatcher()";
    }

    public boolean equals(Object obj) {
        return obj instanceof AdditionalLibraryIgnoresMatcher;
    }

    public int hashCode() {
        return 17;
    }
}

