/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.bytebuddy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;

public class AgentCachingPoolStrategy
implements AgentBuilder.PoolStrategy {
    static final int CONCURRENCY_LEVEL = 8;
    static final int LOADER_CAPACITY = 64;
    static final int TYPE_CAPACITY = 64;
    static final int BOOTSTRAP_HASH = 7236344;
    final Cache<ClassLoader, WeakReference<ClassLoader>> loaderRefCache = CacheBuilder.newBuilder().weakKeys().concurrencyLevel(8).initialCapacity(32).maximumSize(64L).build();
    final Cache<TypeCacheKey, TypePool.Resolution> sharedResolutionCache = CacheBuilder.newBuilder().softValues().concurrencyLevel(8).initialCapacity(64).maximumSize(64L).build();
    final SharedResolutionCacheAdapter bootstrapCacheProvider = new SharedResolutionCacheAdapter(7236344, null, this.sharedResolutionCache);

    public final TypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
        if (classLoader == null) {
            return this.createCachingTypePool(this.bootstrapCacheProvider, classFileLocator);
        }
        WeakReference<ClassLoader> loaderRef = (WeakReference<ClassLoader>)this.loaderRefCache.getIfPresent((Object)classLoader);
        if (loaderRef == null) {
            loaderRef = new WeakReference<ClassLoader>(classLoader);
            this.loaderRefCache.put((Object)classLoader, loaderRef);
        }
        int loaderHash = classLoader.hashCode();
        return this.createCachingTypePool(loaderHash, loaderRef, classFileLocator);
    }

    private TypePool.CacheProvider createCacheProvider(int loaderHash, WeakReference<ClassLoader> loaderRef) {
        return new SharedResolutionCacheAdapter(loaderHash, loaderRef, this.sharedResolutionCache);
    }

    private TypePool createCachingTypePool(int loaderHash, WeakReference<ClassLoader> loaderRef, ClassFileLocator classFileLocator) {
        return new TypePool.Default.WithLazyResolution(this.createCacheProvider(loaderHash, loaderRef), classFileLocator, TypePool.Default.ReaderMode.FAST);
    }

    private TypePool createCachingTypePool(TypePool.CacheProvider cacheProvider, ClassFileLocator classFileLocator) {
        return new TypePool.Default.WithLazyResolution(cacheProvider, classFileLocator, TypePool.Default.ReaderMode.FAST);
    }

    final long approximateSize() {
        return this.sharedResolutionCache.size();
    }

    private static class CachingTypeDescription
    extends TypeDescription.AbstractBase.OfSimpleType.WithDelegation {
        private final TypeDescription delegate;
        private TypeDescription.Generic superClass;
        private TypeList.Generic interfaces;
        private AnnotationList annotations;
        private MethodList<MethodDescription.InDefinedShape> methods;

        public CachingTypeDescription(TypeDescription delegate) {
            this.delegate = delegate;
        }

        protected TypeDescription delegate() {
            return this.delegate;
        }

        public TypeDescription.Generic getSuperClass() {
            if (this.superClass == null) {
                this.superClass = this.delegate.getSuperClass();
            }
            return this.superClass;
        }

        public TypeList.Generic getInterfaces() {
            if (this.interfaces == null) {
                this.interfaces = this.delegate.getInterfaces();
            }
            return this.interfaces;
        }

        public AnnotationList getDeclaredAnnotations() {
            if (this.annotations == null) {
                this.annotations = this.delegate.getDeclaredAnnotations();
            }
            return this.annotations;
        }

        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            if (this.methods == null) {
                this.methods = this.delegate.getDeclaredMethods();
            }
            return this.methods;
        }

        public String getName() {
            return this.delegate.getName();
        }
    }

    private static class CachingResolution
    implements TypePool.Resolution {
        private final TypePool.Resolution delegate;
        private TypeDescription cachedResolution;

        public CachingResolution(TypePool.Resolution delegate) {
            this.delegate = delegate;
        }

        public boolean isResolved() {
            return this.delegate.isResolved();
        }

        public TypeDescription resolve() {
            if (this.cachedResolution == null) {
                this.cachedResolution = new CachingTypeDescription(this.delegate.resolve());
            }
            return this.cachedResolution;
        }
    }

    static final class SharedResolutionCacheAdapter
    implements TypePool.CacheProvider {
        private static final String OBJECT_NAME = "java.lang.Object";
        private static final TypePool.Resolution OBJECT_RESOLUTION = new TypePool.Resolution.Simple((TypeDescription)new CachingTypeDescription(TypeDescription.OBJECT));
        private final int loaderHash;
        private final WeakReference<ClassLoader> loaderRef;
        private final Cache<TypeCacheKey, TypePool.Resolution> sharedResolutionCache;

        SharedResolutionCacheAdapter(int loaderHash, WeakReference<ClassLoader> loaderRef, Cache<TypeCacheKey, TypePool.Resolution> sharedResolutionCache) {
            this.loaderHash = loaderHash;
            this.loaderRef = loaderRef;
            this.sharedResolutionCache = sharedResolutionCache;
        }

        public TypePool.Resolution find(String className) {
            TypePool.Resolution existingResolution = (TypePool.Resolution)this.sharedResolutionCache.getIfPresent((Object)new TypeCacheKey(this.loaderHash, this.loaderRef, className));
            if (existingResolution != null) {
                return existingResolution;
            }
            if (OBJECT_NAME.equals(className)) {
                return OBJECT_RESOLUTION;
            }
            return null;
        }

        public TypePool.Resolution register(String className, TypePool.Resolution resolution) {
            if (OBJECT_NAME.equals(className)) {
                return resolution;
            }
            resolution = new CachingResolution(resolution);
            this.sharedResolutionCache.put((Object)new TypeCacheKey(this.loaderHash, this.loaderRef, className), (Object)resolution);
            return resolution;
        }

        public void clear() {
        }
    }

    static final class TypeCacheKey {
        private final int loaderHash;
        private final WeakReference<ClassLoader> loaderRef;
        private final String className;
        private final int hashCode;

        TypeCacheKey(int loaderHash, WeakReference<ClassLoader> loaderRef, String className) {
            this.loaderHash = loaderHash;
            this.loaderRef = loaderRef;
            this.className = className;
            this.hashCode = Objects.hash(loaderHash, className);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TypeCacheKey)) {
                return false;
            }
            TypeCacheKey other = (TypeCacheKey)obj;
            if (this.loaderHash != other.loaderHash) {
                return false;
            }
            if (!Objects.equals(this.className, other.className)) {
                return false;
            }
            if (this.loaderRef == other.loaderRef) {
                return true;
            }
            ClassLoader thisLoader = (ClassLoader)this.loaderRef.get();
            if (thisLoader == null) {
                return false;
            }
            ClassLoader otherLoader = (ClassLoader)other.loaderRef.get();
            if (otherLoader == null) {
                return false;
            }
            return thisLoader == otherLoader;
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

