/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.auto.service.AutoService;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.config.ConfigBuilder;
import io.opentelemetry.javaagent.instrumentation.api.OpenTelemetrySdkAccess;
import io.opentelemetry.javaagent.spi.ComponentInstaller;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={ComponentInstaller.class})
public class OpenTelemetryInstaller
implements ComponentInstaller {
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryInstaller.class);
    static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";

    public void beforeByteBuddyAgent() {
        OpenTelemetryInstaller.installAgentTracer();
    }

    public static synchronized void installAgentTracer() {
        if (Config.get().getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            OpenTelemetryInstaller.copySystemProperties();
            OpenTelemetrySdk sdk = OpenTelemetrySdkAutoConfiguration.initialize();
            OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> sdk.getSdkTracerProvider().forceFlush().join((long)timeout, unit));
        } else {
            log.info("Tracing is disabled.");
        }
    }

    private static void copySystemProperties() {
        String traceExporter;
        Properties allProperties = Config.get().asJavaProperties();
        Properties environmentProperties = new ConfigBuilder().readEnvironmentVariables().readSystemProperties().build().asJavaProperties();
        allProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String keyStr = (String)key;
            if (!environmentProperties.containsKey(key) && !keyStr.equals("otel.endpoint.peer.service.mapping") && keyStr.startsWith("otel.") && !keyStr.startsWith("otel.instrumentation")) {
                System.setProperty(keyStr, (String)value);
            }
        }));
        Properties environmentPropertiesWithCopies = new ConfigBuilder().readEnvironmentVariables().readSystemProperties().build().asJavaProperties();
        if (!environmentPropertiesWithCopies.containsKey("otel.propagators")) {
            System.setProperty("otel.propagators", "tracecontext,baggage");
        }
        if ((traceExporter = environmentPropertiesWithCopies.getProperty("otel.trace.exporter")) == null) {
            System.setProperty("otel.trace.exporter", "otlp");
        } else if (traceExporter.equals("none")) {
            System.clearProperty("otel.trace.exporter");
        }
        String metricExporter = environmentPropertiesWithCopies.getProperty("otel.metrics.exporter");
        if (metricExporter == null) {
            System.setProperty("otel.metrics.exporter", "otlp");
        } else if (metricExporter.equals("none")) {
            System.clearProperty("otel.metrics.exporter");
        }
    }
}

