/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.matcher;

import io.opentelemetry.javaagent.spi.IgnoreMatcherProvider;
import io.opentelemetry.javaagent.tooling.matcher.AdditionalLibraryIgnoresMatcher;
import java.util.regex.Pattern;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;

public class GlobalIgnoresMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private static final Pattern COM_MCHANGE_PROXY = Pattern.compile("com\\.mchange\\.v2\\.c3p0\\..*Proxy");
    private final ElementMatcher<T> additionalLibraryIgnoreMatcher = AdditionalLibraryIgnoresMatcher.additionalLibraryIgnoresMatcher();
    private final boolean skipAdditionalLibraryMatcher;
    private final IgnoreMatcherProvider ignoreMatcherProvider;

    public static <T extends TypeDescription> ElementMatcher.Junction<T> globalIgnoresMatcher(boolean skipAdditionalLibraryMatcher, IgnoreMatcherProvider ignoreMatcherProviders) {
        return new GlobalIgnoresMatcher<T>(skipAdditionalLibraryMatcher, ignoreMatcherProviders);
    }

    private GlobalIgnoresMatcher(boolean skipAdditionalLibraryMatcher, IgnoreMatcherProvider ignoreMatcherProvider) {
        this.skipAdditionalLibraryMatcher = skipAdditionalLibraryMatcher;
        this.ignoreMatcherProvider = ignoreMatcherProvider;
    }

    public boolean matches(T target) {
        IgnoreMatcherProvider.Result ignoreResult = this.ignoreMatcherProvider.type(target);
        switch (ignoreResult) {
            case IGNORE: {
                return true;
            }
            case ALLOW: {
                return false;
            }
        }
        String name = target.getActualName();
        if (name.startsWith("jdk.internal.net.http.")) {
            return false;
        }
        if (name.startsWith("org.gradle.") || name.startsWith("net.bytebuddy.") || name.startsWith("jdk.") || name.startsWith("org.aspectj.") || name.startsWith("datadog.") || name.startsWith("com.intellij.rt.debugger.") || name.startsWith("com.p6spy.") || name.startsWith("com.dynatrace.") || name.startsWith("com.jloadtrace.") || name.startsWith("com.appdynamics.") || name.startsWith("com.newrelic.agent.") || name.startsWith("com.newrelic.api.agent.") || name.startsWith("com.nr.agent.") || name.startsWith("com.singularity.") || name.startsWith("com.jinspired.") || name.startsWith("org.jinspired.")) {
            return true;
        }
        if (name.startsWith("org.groovy.") || name.startsWith("org.apache.groovy.")) {
            return true;
        }
        if (name.startsWith("org.codehaus.groovy.")) {
            return !name.startsWith("org.codehaus.groovy.runtime.");
        }
        if (name.startsWith("clojure.") || name.contains("$fn__")) {
            return true;
        }
        if (name.startsWith("io.opentelemetry.auto.")) {
            return !name.equals("io.opentelemetry.javaagent.instrumentation.api.concurrent.RunnableWrapper") && !name.equals("io.opentelemetry.javaagent.instrumentation.api.concurrent.CallableWrapper");
        }
        if (name.startsWith("java.")) {
            if (name.equals("java.net.URL") || name.equals("java.net.HttpURLConnection")) {
                return false;
            }
            if (name.startsWith("java.rmi.") || name.startsWith("java.util.concurrent.")) {
                return false;
            }
            if (name.equals("java.lang.ClassLoader")) {
                return false;
            }
            return !name.startsWith("java.util.logging.") || name.equals("java.util.logging.LogManager$Cleaner");
        }
        if (name.startsWith("com.sun.")) {
            return !name.startsWith("com.sun.messaging.") && !name.startsWith("com.sun.jersey.api.client") && !name.startsWith("com.sun.appserv");
        }
        if (name.startsWith("sun.")) {
            return !name.startsWith("sun.net.www.protocol.") && !name.startsWith("sun.rmi.server") && !name.startsWith("sun.rmi.transport") && !name.equals("sun.net.www.http.HttpClient");
        }
        if (name.startsWith("org.slf4j.")) {
            return !name.equals("org.slf4j.MDC");
        }
        if (name.contains("$JaxbAccessor") || name.contains("CGLIB$$") || name.contains("javassist") || name.contains(".asm.") || name.contains("$__sisu") || name.contains("$$EnhancerByProxool$$") || name.startsWith("org.springframework.core.$Proxy")) {
            return true;
        }
        if (COM_MCHANGE_PROXY.matcher(name).matches()) {
            return true;
        }
        return !this.skipAdditionalLibraryMatcher && this.additionalLibraryIgnoreMatcher.matches(target);
    }

    public String toString() {
        return "globalIgnoresMatcher(" + this.additionalLibraryIgnoreMatcher.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GlobalIgnoresMatcher)) {
            return false;
        }
        GlobalIgnoresMatcher other = (GlobalIgnoresMatcher)((Object)obj);
        return this.additionalLibraryIgnoreMatcher.equals(other.additionalLibraryIgnoreMatcher);
    }

    public int hashCode() {
        return this.additionalLibraryIgnoreMatcher.hashCode();
    }
}

