/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.matcher;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.matcher.ElementMatcher;

public final class NameMatchers {
    public static <T extends NamedElement> ElementMatcher.Junction<T> namedOneOf(String ... names) {
        return new SetMatcher(true, names);
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> namedOneOf(Collection<String> names) {
        return new SetMatcher(true, names);
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> namedNoneOf(String ... names) {
        return new SetMatcher(false, names);
    }

    private static class SetMatcher<T extends NamedElement>
    extends ElementMatcher.Junction.AbstractBase<T> {
        private final boolean include;
        private final Set<String> values;

        private SetMatcher(boolean include, String ... values) {
            this.include = include;
            this.values = new HashSet<String>(values.length * 2);
            for (String value : values) {
                this.values.add(value);
            }
        }

        private SetMatcher(boolean include, Collection<String> values) {
            this.include = include;
            this.values = new HashSet<String>(values.size() * 2);
            this.values.addAll(values);
        }

        public boolean matches(T target) {
            boolean contained = this.values.contains(target.getActualName());
            return this.include && contained || !this.include && !contained;
        }
    }
}

