/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.tooling.ShadingRemapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ClassWriter;
import net.bytebuddy.jar.asm.commons.ClassRemapper;
import net.bytebuddy.jar.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(ExporterClassLoader.class);
    private static final ShadingRemapper remapper = new ShadingRemapper(ShadingRemapper.rule("#io.opentelemetry.api", "#io.opentelemetry.javaagent.shaded.io.opentelemetry.api"), ShadingRemapper.rule("#io.opentelemetry.context", "#io.opentelemetry.javaagent.shaded.io.opentelemetry.context"), ShadingRemapper.rule("#java.util.logging.Logger", "#io.opentelemetry.javaagent.bootstrap.PatchLogger"), ShadingRemapper.rule("#org.slf4j", "#io.opentelemetry.javaagent.slf4j"));
    private final Manifest manifest;

    public ExporterClassLoader(URL url, ClassLoader parent) {
        super(new URL[]{url}, parent);
        this.manifest = ExporterClassLoader.getManifest(url);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name.equals("META-INF/services/io.opentelemetry.javaagent.spi.exporter.SpanExporterFactory") || name.equals("META-INF/services/io.opentelemetry.javaagent.spi.exporter.MetricExporterFactory")) {
            return this.findResources(name);
        }
        return super.getResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        InputStream in = this.getResourceAsStream(name.replace('.', '/') + ".class");
        if (in == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            byte[] bytes = ExporterClassLoader.remapClassBytes(in);
            this.definePackageIfNeeded(name);
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void definePackageIfNeeded(String className) {
        block4: {
            String packageName = ExporterClassLoader.getPackageName(className);
            if (packageName == null) {
                return;
            }
            if (this.isPackageDefined(packageName)) {
                return;
            }
            try {
                this.definePackage(packageName);
            }
            catch (IllegalArgumentException e) {
                if (this.isPackageDefined(packageName)) break block4;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isPackageDefined(String packageName) {
        return this.getPackage(packageName) != null;
    }

    private void definePackage(String packageName) {
        if (this.manifest == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        } else {
            this.definePackage(packageName, this.manifest, null);
        }
    }

    private static byte[] remapClassBytes(InputStream in) throws IOException {
        ClassWriter cw = new ClassWriter(0);
        ClassReader cr = new ClassReader(in);
        cr.accept((ClassVisitor)new ClassRemapper((ClassVisitor)cw, (Remapper)remapper), 8);
        return cw.toByteArray();
    }

    private static String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        return index == -1 ? null : className.substring(0, index);
    }

    private static Manifest getManifest(URL url) {
        try {
            JarFile jarFile = new JarFile(url.getFile());
            return jarFile.getManifest();
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

