/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.internal.BootstrapPackagePrefixesHolder;
import io.opentelemetry.javaagent.instrumentation.api.OpenTelemetrySdkAccess;
import io.opentelemetry.javaagent.instrumentation.api.SafeServiceLoader;
import io.opentelemetry.javaagent.spi.BootstrapPackagesProvider;
import io.opentelemetry.javaagent.spi.ByteBuddyAgentCustomizer;
import io.opentelemetry.javaagent.tooling.AgentTooling;
import io.opentelemetry.javaagent.tooling.ClassLoaderMatcher;
import io.opentelemetry.javaagent.tooling.Constants;
import io.opentelemetry.javaagent.tooling.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.config.ConfigInitializer;
import io.opentelemetry.javaagent.tooling.context.FieldBackedProvider;
import io.opentelemetry.javaagent.tooling.matcher.GlobalIgnoresMatcher;
import io.opentelemetry.javaagent.tooling.matcher.NameMatchers;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInstaller {
    private static final Logger log = LoggerFactory.getLogger(AgentInstaller.class);
    private static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    private static final String EXCLUDED_CLASSES_CONFIG = "otel.javaagent.exclude-classes";
    private static final Map<String, List<Runnable>> CLASS_LOAD_CALLBACKS = new HashMap<String, List<Runnable>>();
    private static volatile Instrumentation INSTRUMENTATION;

    public static Instrumentation getInstrumentation() {
        return INSTRUMENTATION;
    }

    public static void installBytebuddyAgent(Instrumentation inst) {
        if (Config.get().getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            AgentInstaller.installBytebuddyAgent(inst, false, new AgentBuilder.Listener[0]);
        } else {
            log.debug("Tracing is disabled, not installing instrumentations.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResettableClassFileTransformer installBytebuddyAgent(Instrumentation inst, boolean skipAdditionalLibraryMatcher, AgentBuilder.Listener ... listeners) {
        ClassLoader savedContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AgentInstaller.class.getClassLoader());
            OpenTelemetry.getGlobalTracerProvider();
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedContextClassLoader);
        }
        OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> OpenTelemetrySdk.getGlobalTracerManagement().forceFlush().join((long)timeout, unit));
        INSTRUMENTATION = inst;
        AgentInstaller.addByteBuddyRawSetting();
        FieldBackedProvider.resetContextMatchers();
        AgentBuilder.Ignored ignoredAgentBuilder = new AgentBuilder.Default().disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE).with((AgentBuilder.DescriptionStrategy)AgentBuilder.DescriptionStrategy.Default.POOL_ONLY).with((AgentBuilder.PoolStrategy)AgentTooling.poolStrategy()).with((AgentBuilder.Listener)new ClassLoadListener()).with((AgentBuilder.LocationStrategy)AgentTooling.locationStrategy()).ignore((ElementMatcher)ElementMatchers.any(), ClassLoaderMatcher.skipClassLoader());
        ignoredAgentBuilder = (AgentBuilder.Ignored)ignoredAgentBuilder.or(GlobalIgnoresMatcher.globalIgnoresMatcher(skipAdditionalLibraryMatcher));
        AgentBuilder.Ignored agentBuilder = ignoredAgentBuilder = (AgentBuilder.Ignored)ignoredAgentBuilder.or(AgentInstaller.matchesConfiguredExcludes());
        if (log.isDebugEnabled()) {
            agentBuilder = agentBuilder.with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE).with((AgentBuilder.RedefinitionStrategy.Listener)new RedefinitionLoggingListener()).with((AgentBuilder.Listener)new TransformLoggingListener());
        }
        for (AgentBuilder.Listener listener : listeners) {
            agentBuilder = agentBuilder.with(listener);
        }
        int numInstrumenters = 0;
        for (InstrumentationModule instrumentationModule : AgentInstaller.loadInstrumentationModules()) {
            log.debug("Loading instrumentation {}", (Object)instrumentationModule.getClass().getName());
            try {
                agentBuilder = instrumentationModule.instrument((AgentBuilder)agentBuilder);
                ++numInstrumenters;
            }
            catch (Exception | LinkageError e) {
                log.error("Unable to load instrumentation {}", (Object)instrumentationModule.getClass().getName(), (Object)e);
            }
        }
        agentBuilder = AgentInstaller.customizeByteBuddyAgent((AgentBuilder)agentBuilder);
        log.debug("Installed {} instrumenter(s)", (Object)numInstrumenters);
        return agentBuilder.installOn(inst);
    }

    private static AgentBuilder customizeByteBuddyAgent(AgentBuilder agentBuilder) {
        Iterable<ByteBuddyAgentCustomizer> agentCustomizers = AgentInstaller.loadByteBuddyAgentCustomizers();
        for (ByteBuddyAgentCustomizer agentCustomizer : agentCustomizers) {
            log.debug("Applying agent builder customizer {}", (Object)agentCustomizer.getClass().getName());
            agentBuilder = agentCustomizer.customize(agentBuilder);
        }
        return agentBuilder;
    }

    private static Iterable<ByteBuddyAgentCustomizer> loadByteBuddyAgentCustomizers() {
        return ServiceLoader.load(ByteBuddyAgentCustomizer.class, AgentInstaller.class.getClassLoader());
    }

    private static List<InstrumentationModule> loadInstrumentationModules() {
        return SafeServiceLoader.load(InstrumentationModule.class, (ClassLoader)AgentInstaller.class.getClassLoader()).stream().sorted(Comparator.comparingInt(InstrumentationModule::getOrder)).collect(Collectors.toList());
    }

    private static void addByteBuddyRawSetting() {
        String savedPropertyValue = System.getProperty("net.bytebuddy.raw");
        try {
            System.setProperty("net.bytebuddy.raw", "true");
            boolean rawTypes = TypeDescription.AbstractBase.RAW_TYPES;
            if (!rawTypes) {
                log.debug("Too late to enable {}", (Object)"net.bytebuddy.raw");
            }
        }
        finally {
            if (savedPropertyValue == null) {
                System.clearProperty("net.bytebuddy.raw");
            } else {
                System.setProperty("net.bytebuddy.raw", savedPropertyValue);
            }
        }
    }

    private static ElementMatcher.Junction<Object> matchesConfiguredExcludes() {
        List excludedClasses = Config.get().getListProperty(EXCLUDED_CLASSES_CONFIG);
        ElementMatcher.Junction matcher = ElementMatchers.none();
        ArrayList<String> literals = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String excludedClass : excludedClasses) {
            if ((excludedClass = excludedClass.trim()).endsWith("*")) {
                prefixes.add(excludedClass.substring(0, excludedClass.length() - 1));
                continue;
            }
            literals.add(excludedClass);
        }
        if (!literals.isEmpty()) {
            matcher = matcher.or(NameMatchers.namedOneOf(literals));
        }
        for (String prefix : prefixes) {
            matcher = matcher.or((ElementMatcher)ElementMatchers.nameStartsWith((String)prefix));
        }
        return matcher;
    }

    private static List<String> loadBootstrapPackagePrefixes() {
        ArrayList<String> bootstrapPackages = new ArrayList<String>(Arrays.asList(Constants.BOOTSTRAP_PACKAGE_PREFIXES));
        List bootstrapPackagesProviders = SafeServiceLoader.load(BootstrapPackagesProvider.class, (ClassLoader)AgentInstaller.class.getClassLoader());
        for (BootstrapPackagesProvider provider : bootstrapPackagesProviders) {
            List packagePrefixes = provider.getPackagePrefixes();
            log.debug("Loaded bootstrap package prefixes from {}: {}", (Object)provider.getClass().getName(), (Object)packagePrefixes);
            bootstrapPackages.addAll(packagePrefixes);
        }
        return bootstrapPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoadCallback(String className, Runnable callback) {
        Map<String, List<Runnable>> map = CLASS_LOAD_CALLBACKS;
        synchronized (map) {
            List callbacks = CLASS_LOAD_CALLBACKS.computeIfAbsent(className, k -> new ArrayList());
            callbacks.add(callback);
        }
    }

    private AgentInstaller() {
    }

    static {
        BootstrapPackagePrefixesHolder.setBoostrapPackagePrefixes(AgentInstaller.loadBootstrapPackagePrefixes());
        AgentTooling.registerWeakMapProvider();
        ConfigInitializer.initialize();
    }

    private static class ClassLoadListener
    implements AgentBuilder.Listener {
        private ClassLoadListener() {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b, DynamicType dynamicType) {
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onError(String s, ClassLoader classLoader, JavaModule javaModule, boolean b, Throwable throwable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
            Map map = CLASS_LOAD_CALLBACKS;
            synchronized (map) {
                List callbacks = (List)CLASS_LOAD_CALLBACKS.get(typeName);
                if (callbacks != null) {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                }
            }
        }
    }

    static class TransformLoggingListener
    implements AgentBuilder.Listener {
        private static final Logger log = LoggerFactory.getLogger(TransformLoggingListener.class);

        TransformLoggingListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to handle {} for transformation on classloader {}: {}", new Object[]{typeName, classLoader, throwable.getMessage()});
            }
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            log.debug("Transformed {} -- {}", (Object)typeDescription.getName(), (Object)classLoader);
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }
    }

    static class RedefinitionLoggingListener
    implements AgentBuilder.RedefinitionStrategy.Listener {
        private static final Logger log = LoggerFactory.getLogger(RedefinitionLoggingListener.class);

        RedefinitionLoggingListener() {
        }

        public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
        }

        public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
            if (log.isDebugEnabled()) {
                log.debug("Exception while retransforming " + batch.size() + " classes: " + batch, throwable);
            }
            return Collections.emptyList();
        }

        public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
        }
    }
}

