/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.executors;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.internal.ContextPropagationDebug;

public final class ContextPropagatingRunnable
implements Runnable {
    private final Runnable delegate;
    private final Context context;

    public static boolean shouldDecorateRunnable(Runnable task) {
        return task.getClass().getName().contains("/") && !(task instanceof ContextPropagatingRunnable);
    }

    public static Runnable propagateContext(Runnable task, Context context) {
        return new ContextPropagatingRunnable(task, context);
    }

    private ContextPropagatingRunnable(Runnable delegate, Context context) {
        this.delegate = delegate;
        this.context = ContextPropagationDebug.addDebugInfo((Context)context, (Object)delegate);
    }

    @Override
    public void run() {
        try (Scope ignored = this.context.makeCurrent();){
            this.delegate.run();
        }
    }

    public Runnable unwrap() {
        return this.delegate;
    }
}

