/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpClientInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpServerInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.incubator.config.internal.CommonConfig;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import java.util.function.Function;

public final class InstrumentationConfigUtil {
    private InstrumentationConfigUtil() {
    }

    @CanIgnoreReturnValue
    public static <T, REQUEST, RESPONSE> T configureClientBuilder(InstrumentationConfig config, T builder, Function<T, DefaultHttpClientInstrumenterBuilder<REQUEST, RESPONSE>> getBuilder) {
        getBuilder.apply(builder).configure(InstrumentationConfigUtil.getConfig(config));
        return builder;
    }

    @CanIgnoreReturnValue
    public static <T, REQUEST, RESPONSE> T configureServerBuilder(InstrumentationConfig config, T builder, Function<T, DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE>> getBuilder) {
        getBuilder.apply(builder).configure(InstrumentationConfigUtil.getConfig(config));
        return builder;
    }

    private static CommonConfig getConfig(InstrumentationConfig config) {
        return new CommonConfig(config);
    }

    public static boolean isStatementSanitizationEnabled(InstrumentationConfig config, String key) {
        return config.getBoolean(key, config.getBoolean("otel.instrumentation.common.db-statement-sanitizer.enabled", true));
    }
}

