/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.mongo;

import com.mongodb.MongoClientSettings;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.ConditionalOnEnabledInstrumentation;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.InstrumentationConfigUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={MongoClientSettings.class, MongoClientSettingsBuilderCustomizer.class})
@ConditionalOnEnabledInstrumentation(module="mongo")
@Configuration
public class MongoClientInstrumentationAutoConfiguration {
    @Bean
    MongoClientSettingsBuilderCustomizer customizer(OpenTelemetry openTelemetry, InstrumentationConfig config) {
        return builder -> builder.addCommandListener(MongoTelemetry.builder((OpenTelemetry)openTelemetry).setStatementSanitizationEnabled(InstrumentationConfigUtil.isStatementSanitizationEnabled(config, "otel.instrumentation.mongo.statement-sanitizer.enabled")).build().newCommandListener());
    }
}

