/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.jdbc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetry;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetryBuilder;
import io.opentelemetry.instrumentation.jdbc.datasource.internal.Experimental;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.jdbc.DataSourcePostProcessor$DataSource$;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.InstrumentationConfigUtil;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

final class DataSourcePostProcessor
implements BeanPostProcessor,
Ordered {
    @Nullable
    private static final Class<?> ROUTING_DATA_SOURCE_CLASS = DataSourcePostProcessor.getRoutingDataSourceClass();
    private final ObjectProvider<OpenTelemetry> openTelemetryProvider;
    private final ObjectProvider<InstrumentationConfig> configProvider;

    DataSourcePostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<InstrumentationConfig> configProvider) {
        this.openTelemetryProvider = openTelemetryProvider;
        this.configProvider = configProvider;
    }

    @Nullable
    private static Class<?> getRoutingDataSourceClass() {
        try {
            return Class.forName("org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource");
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    private static boolean isRoutingDatasource(Object bean) {
        return ROUTING_DATA_SOURCE_CLASS != null && ROUTING_DATA_SOURCE_CLASS.isInstance(bean);
    }

    @CanIgnoreReturnValue
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof DataSource && !DataSourcePostProcessor.isRoutingDatasource(bean) && !ScopedProxyUtils.isScopedTarget((String)beanName)) {
            DataSource dataSource = (DataSource)bean;
            InstrumentationConfig config = (InstrumentationConfig)this.configProvider.getObject();
            JdbcTelemetryBuilder builder = JdbcTelemetry.builder((OpenTelemetry)((OpenTelemetry)this.openTelemetryProvider.getObject())).setStatementSanitizationEnabled(InstrumentationConfigUtil.isStatementSanitizationEnabled(config, "otel.instrumentation.jdbc.statement-sanitizer.enabled")).setCaptureQueryParameters(config.getBoolean("otel.instrumentation.jdbc.experimental.capture-query-parameters", false)).setTransactionInstrumenterEnabled(config.getBoolean("otel.instrumentation.jdbc.experimental.transaction.enabled", false)).setDataSourceInstrumenterEnabled(config.getBoolean("otel.instrumentation.jdbc.experimental.datasource.enabled", false));
            Experimental.setEnableSqlCommenter((JdbcTelemetryBuilder)builder, (boolean)config.getBoolean("otel.instrumentation.jdbc.experimental.sqlcommenter.enabled", false));
            DataSource otelDataSource = builder.build().wrap(dataSource);
            return new DataSource$$Wrapper(otelDataSource, dataSource);
        }
        return bean;
    }

    public int getOrder() {
        return 2147483627;
    }
}

