/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.annotations;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.annotation.support.MethodSpanAttributesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndSupport;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.annotations.JoinPointRequest;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.annotations.JointPointCodeAttributesExtractor;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.annotations.WithSpanAspectParameterAttributeNamesExtractor;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.ParameterNameDiscoverer;

abstract class WithSpanAspect {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-boot-autoconfigure";
    private final Instrumenter<JoinPointRequest, Object> instrumenter;
    private final JoinPointRequest.Factory requestFactory;

    WithSpanAspect(OpenTelemetry openTelemetry, ParameterNameDiscoverer parameterNameDiscoverer, JoinPointRequest.Factory requestFactory, WithSpanAspectParameterAttributeNamesExtractor.SpanAttributeNameSupplier spanAttributeNameSupplier) {
        WithSpanAspectParameterAttributeNamesExtractor parameterAttributeNamesExtractor = new WithSpanAspectParameterAttributeNamesExtractor(parameterNameDiscoverer, spanAttributeNameSupplier);
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, JoinPointRequest::spanName).addAttributesExtractor(CodeAttributesExtractor.create((CodeAttributesGetter)JointPointCodeAttributesExtractor.INSTANCE)).addAttributesExtractor((AttributesExtractor)MethodSpanAttributesExtractor.create(JoinPointRequest::method, (ParameterAttributeNamesExtractor)parameterAttributeNamesExtractor, JoinPointRequest::args)).addContextCustomizer(WithSpanAspect::parentContext).buildInstrumenter(JoinPointRequest::spanKind);
        this.requestFactory = requestFactory;
    }

    private static Context parentContext(Context parentContext, JoinPointRequest request, Attributes unused) {
        return request.inheritContext() ? parentContext : Context.root();
    }

    @Nullable
    public Object traceMethod(ProceedingJoinPoint pjp) throws Throwable {
        Object response;
        JoinPointRequest request = this.requestFactory.create((JoinPoint)pjp);
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            return pjp.proceed();
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        AsyncOperationEndSupport asyncOperationEndSupport = AsyncOperationEndSupport.create(this.instrumenter, Object.class, request.method().getReturnType());
        try (Scope ignored = context.makeCurrent();){
            response = pjp.proceed();
        }
        catch (Throwable t) {
            asyncOperationEndSupport.asyncEnd(context, (Object)request, null, t);
            throw t;
        }
        return asyncOperationEndSupport.asyncEnd(context, (Object)request, response, null);
    }
}

