/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;

public final class DeprecatedConfigProperties {
    private static final Logger logger = Logger.getLogger(DeprecatedConfigProperties.class.getName());

    public static Boolean getBoolean(ApplicationEnvironmentPreparedEvent event, String deprecatedPropertyName, String newPropertyName) {
        DeprecatedConfigProperties.warnIfUsed(event, deprecatedPropertyName, newPropertyName);
        Boolean value = (Boolean)event.getEnvironment().getProperty(deprecatedPropertyName, Boolean.class);
        if (value != null) {
            return value;
        }
        return (Boolean)event.getEnvironment().getProperty(newPropertyName, Boolean.class);
    }

    private static void warnIfUsed(ApplicationEnvironmentPreparedEvent event, String deprecatedPropertyName, String newPropertyName) {
        String value = (String)event.getEnvironment().getProperty(deprecatedPropertyName, String.class);
        if (value != null) {
            logger.log(Level.WARNING, "Deprecated property \"{0}\" was used; use the \"{1}\" property instead", new Object[]{deprecatedPropertyName, newPropertyName});
        }
    }

    private DeprecatedConfigProperties() {
    }
}

