/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.internal.SqlCommenter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.internal.SqlCommenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.R2dbcTelemetry;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.DbExecution;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.Experimental;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.R2dbcInstrumenterBuilder;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class R2dbcTelemetryBuilder {
    private final R2dbcInstrumenterBuilder instrumenterBuilder;
    private boolean statementSanitizationEnabled = true;
    private UnaryOperator<SpanNameExtractor<DbExecution>> spanNameExtractorTransformer = UnaryOperator.identity();
    private final SqlCommenterBuilder sqlCommenterBuilder = SqlCommenter.builder();

    R2dbcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.instrumenterBuilder = new R2dbcInstrumenterBuilder(openTelemetry);
    }

    @CanIgnoreReturnValue
    public R2dbcTelemetryBuilder addAttributesExtractor(AttributesExtractor<DbExecution, Void> attributesExtractor) {
        this.instrumenterBuilder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public R2dbcTelemetryBuilder setStatementSanitizationEnabled(boolean enabled) {
        this.statementSanitizationEnabled = enabled;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public R2dbcTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<DbExecution>, ? extends SpanNameExtractor<? super DbExecution>> spanNameExtractorTransformer) {
        return this.setSpanNameExtractor(input -> (SpanNameExtractor)spanNameExtractorTransformer.apply((SpanNameExtractor<DbExecution>)input));
    }

    @CanIgnoreReturnValue
    public R2dbcTelemetryBuilder setSpanNameExtractor(UnaryOperator<SpanNameExtractor<DbExecution>> spanNameExtractor) {
        this.spanNameExtractorTransformer = spanNameExtractor;
        return this;
    }

    public R2dbcTelemetry build() {
        return new R2dbcTelemetry(this.instrumenterBuilder.build(this.spanNameExtractorTransformer, this.statementSanitizationEnabled), this.sqlCommenterBuilder.build());
    }

    static {
        Experimental.internalSetSqlCommenterBuilder(builder -> builder.sqlCommenterBuilder);
    }
}

