/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.logging;

import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.SdkEnabled;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Conditional(value={SdkEnabled.class})
@ConditionalOnProperty(name={"otel.spring-starter.debug"}, havingValue="true")
@ConditionalOnClass(value={LoggingSpanExporter.class})
@Configuration
public class LoggingExporterAutoConfiguration {
    @Bean
    public AutoConfigurationCustomizerProvider loggingOtelCustomizer() {
        return p -> p.addTracerProviderCustomizer((builder, config) -> {
            LoggingExporterAutoConfiguration.enableLoggingExporter(builder, config);
            return builder;
        });
    }

    public static void enableLoggingExporter(SdkTracerProviderBuilder builder, ConfigProperties config) {
        if (LoggingExporterAutoConfiguration.loggingExporterIsNotAlreadyConfigured(config)) {
            builder.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)LoggingSpanExporter.create()));
        }
    }

    private static boolean loggingExporterIsNotAlreadyConfigured(ConfigProperties config) {
        return !config.getList("otel.traces.exporter", Collections.emptyList()).contains("logging");
    }
}

