/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.jdbc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetry;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetryBuilder;
import io.opentelemetry.instrumentation.jdbc.datasource.internal.Experimental;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.jdbc.DataSourcePostProcessor$DataSource$;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.InstrumentationConfigUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import javax.sql.DataSource;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

final class DataSourcePostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Class<?> ROUTING_DATA_SOURCE_CLASS = DataSourcePostProcessor.getRoutingDataSourceClass();
    private final ObjectProvider<OpenTelemetry> openTelemetryProvider;
    private final ObjectProvider<ConfigProperties> configPropertiesProvider;

    DataSourcePostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<ConfigProperties> configPropertiesProvider) {
        this.openTelemetryProvider = openTelemetryProvider;
        this.configPropertiesProvider = configPropertiesProvider;
    }

    private static Class<?> getRoutingDataSourceClass() {
        try {
            return Class.forName("org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource");
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    private static boolean isRoutingDatasource(Object bean) {
        return ROUTING_DATA_SOURCE_CLASS != null && ROUTING_DATA_SOURCE_CLASS.isInstance(bean);
    }

    @CanIgnoreReturnValue
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof DataSource && !DataSourcePostProcessor.isRoutingDatasource(bean) && !ScopedProxyUtils.isScopedTarget((String)beanName)) {
            DataSource dataSource = (DataSource)bean;
            JdbcTelemetryBuilder builder = JdbcTelemetry.builder((OpenTelemetry)((OpenTelemetry)this.openTelemetryProvider.getObject())).setStatementSanitizationEnabled(InstrumentationConfigUtil.isStatementSanitizationEnabled((ConfigProperties)this.configPropertiesProvider.getObject(), "otel.instrumentation.jdbc.statement-sanitizer.enabled")).setCaptureQueryParameters(((ConfigProperties)this.configPropertiesProvider.getObject()).getBoolean("otel.instrumentation.jdbc.experimental.capture-query-parameters", false)).setTransactionInstrumenterEnabled(((ConfigProperties)this.configPropertiesProvider.getObject()).getBoolean("otel.instrumentation.jdbc.experimental.transaction.enabled", false));
            Experimental.setEnableSqlCommenter((JdbcTelemetryBuilder)builder, (boolean)((ConfigProperties)this.configPropertiesProvider.getObject()).getBoolean("otel.instrumentation.jdbc.experimental.sqlcommenter.enabled", false));
            DataSource otelDataSource = builder.build().wrap(dataSource);
            return new DataSource$$Wrapper(otelDataSource, dataSource);
        }
        return bean;
    }

    public int getOrder() {
        return 2147483627;
    }
}

