/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.MapConverter;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.SdkEnabled;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtelResourceProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtelSpringProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtlpExporterProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.SpringConfigProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.resources.DistroVersionResourceProvider;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.resources.SpringResourceProvider;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.internal.ComponentLoader;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={OtlpExporterProperties.class, OtelResourceProperties.class, OtelSpringProperties.class})
public class OpenTelemetryAutoConfiguration {

    static class OpenTelemetrySdkComponentLoader
    implements ComponentLoader {
        private final ApplicationContext applicationContext;
        private final SpiHelper spiHelper = SpiHelper.create((ClassLoader)OpenTelemetrySdkComponentLoader.class.getClassLoader());

        public OpenTelemetrySdkComponentLoader(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public <T> Iterable<T> load(Class<T> spiClass) {
            List spi = this.spiHelper.load(spiClass);
            List beans = this.applicationContext.getBeanProvider(spiClass).orderedStream().collect(Collectors.toList());
            spi.addAll(beans);
            return spi;
        }
    }

    @Configuration
    @ConditionalOnBean(value={OpenTelemetry.class})
    @ConditionalOnMissingBean(value={ConfigProperties.class})
    static class FallbackConfigProperties {
        FallbackConfigProperties() {
        }

        @Bean
        public ConfigProperties otelProperties() {
            return DefaultConfigProperties.create(Collections.emptyMap());
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    @ConditionalOnProperty(name={"otel.sdk.disabled"}, havingValue="true")
    static class DisabledOpenTelemetrySdkConfig {
        DisabledOpenTelemetrySdkConfig() {
        }

        @Bean
        public OpenTelemetry openTelemetry() {
            return OpenTelemetry.noop();
        }

        @Bean
        public ConfigProperties otelProperties() {
            return DefaultConfigProperties.createFromMap(Collections.emptyMap());
        }
    }

    @Configuration
    @Conditional(value={SdkEnabled.class})
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    static class OpenTelemetrySdkConfig {
        OpenTelemetrySdkConfig() {
        }

        @Bean
        @ConfigurationPropertiesBinding
        public MapConverter mapConverter() {
            return new MapConverter();
        }

        @Bean
        public OpenTelemetrySdkComponentLoader openTelemetrySdkComponentLoader(ApplicationContext applicationContext) {
            return new OpenTelemetrySdkComponentLoader(applicationContext);
        }

        @Bean
        public ResourceProvider otelSpringResourceProvider(Optional<BuildProperties> buildProperties) {
            return new SpringResourceProvider(buildProperties);
        }

        @Bean
        public ResourceProvider otelDistroVersionResourceProvider() {
            return new DistroVersionResourceProvider();
        }

        @Bean
        public AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk(Environment env, OtlpExporterProperties otlpExporterProperties, OtelResourceProperties resourceProperties, OtelSpringProperties otelSpringProperties, OpenTelemetrySdkComponentLoader componentLoader) {
            return AutoConfigureUtil.setComponentLoader((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfigureUtil.setConfigPropertiesCustomizer((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder(), c -> SpringConfigProperties.create(env, otlpExporterProperties, resourceProperties, otelSpringProperties, c)), (ComponentLoader)componentLoader).build();
        }

        @Bean
        public OpenTelemetry openTelemetry(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
            return autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk();
        }

        @Bean
        public ConfigProperties otelProperties(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
            return AutoConfigureUtil.getConfig((AutoConfiguredOpenTelemetrySdk)autoConfiguredOpenTelemetrySdk);
        }
    }
}

