/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.aspects;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.extension.annotations.WithSpan;
import io.opentelemetry.instrumentation.spring.autoconfigure.aspects.TraceAspectProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.aspects.WithSpanAspect;
import io.opentelemetry.instrumentation.spring.autoconfigure.aspects.WithSpanAspectAttributeBinder;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

@Configuration
@EnableConfigurationProperties(value={TraceAspectProperties.class})
@ConditionalOnProperty(prefix="otel.springboot.aspects", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Aspect.class, WithSpan.class})
public class TraceAspectAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ParameterNameDiscoverer parameterNameDiscoverer() {
        return new DefaultParameterNameDiscoverer();
    }

    @Bean
    public WithSpanAspectAttributeBinder withSpanAspectAttributeBinder(ParameterNameDiscoverer parameterNameDiscoverer) {
        return new WithSpanAspectAttributeBinder(parameterNameDiscoverer);
    }

    @Bean
    public WithSpanAspect withSpanAspect(OpenTelemetry openTelemetry, WithSpanAspectAttributeBinder withSpanAspectAttributeBinder) {
        return new WithSpanAspect(openTelemetry, withSpanAspectAttributeBinder);
    }
}

