/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.aspects;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.extension.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.annotation.support.AttributeBindings;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.api.tracer.SpanNames;
import io.opentelemetry.instrumentation.api.tracer.async.AsyncSpanEndStrategies;
import io.opentelemetry.instrumentation.api.tracer.async.AsyncSpanEndStrategy;
import io.opentelemetry.instrumentation.spring.autoconfigure.aspects.WithSpanAspectAttributeBinder;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;

class WithSpanAspectTracer
extends BaseTracer {
    private final WithSpanAspectAttributeBinder withSpanAspectAttributeBinder;
    private final AsyncSpanEndStrategies asyncSpanEndStrategies = AsyncSpanEndStrategies.getInstance();

    WithSpanAspectTracer(OpenTelemetry openTelemetry, WithSpanAspectAttributeBinder withSpanAspectAttributeBinder) {
        super(openTelemetry);
        this.withSpanAspectAttributeBinder = withSpanAspectAttributeBinder;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.spring-boot-autoconfigure-aspect";
    }

    Context startSpan(Context parentContext, WithSpan annotation, Method method, JoinPoint joinPoint) {
        SpanBuilder spanBuilder = this.spanBuilder(parentContext, WithSpanAspectTracer.spanName(annotation, method), annotation.kind());
        Span span = this.withSpanAttributes(spanBuilder, method, joinPoint).startSpan();
        switch (annotation.kind()) {
            case SERVER: {
                return this.withServerSpan(parentContext, span);
            }
            case CLIENT: {
                return this.withClientSpan(parentContext, span);
            }
        }
        return parentContext.with((ImplicitContextKeyed)span);
    }

    private static String spanName(WithSpan annotation, Method method) {
        String spanName = annotation.value();
        if (spanName.isEmpty()) {
            return SpanNames.fromMethod((Method)method);
        }
        return spanName;
    }

    public SpanBuilder withSpanAttributes(SpanBuilder spanBuilder, Method method, JoinPoint joinPoint) {
        AttributeBindings bindings = this.withSpanAspectAttributeBinder.bind(method);
        if (!bindings.isEmpty()) {
            bindings.apply((arg_0, arg_1) -> ((SpanBuilder)spanBuilder).setAttribute(arg_0, arg_1), joinPoint.getArgs());
        }
        return spanBuilder;
    }

    public Object end(Context context, Class<?> returnType, Object returnValue) {
        AsyncSpanEndStrategy asyncSpanEndStrategy;
        if (returnType.isInstance(returnValue) && (asyncSpanEndStrategy = this.asyncSpanEndStrategies.resolveStrategy(returnType)) != null) {
            return asyncSpanEndStrategy.end((BaseTracer)this, context, returnValue);
        }
        this.end(context);
        return returnValue;
    }
}

