/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.aspects;

import io.opentelemetry.extension.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.api.annotation.support.AttributeBindings;
import io.opentelemetry.instrumentation.api.annotation.support.BaseAttributeBinder;
import io.opentelemetry.instrumentation.api.caching.Cache;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.core.ParameterNameDiscoverer;

public class WithSpanAspectAttributeBinder
extends BaseAttributeBinder {
    private static final Cache<Method, AttributeBindings> bindings = Cache.newBuilder().setWeakKeys().build();
    private final ParameterNameDiscoverer parameterNameDiscoverer;

    public WithSpanAspectAttributeBinder(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public AttributeBindings bind(Method method) {
        return (AttributeBindings)bindings.computeIfAbsent((Object)method, x$0 -> super.bind(x$0));
    }

    protected @Nullable String[] attributeNamesForParameters(Method method, Parameter[] parameters) {
        String[] parameterNames = this.parameterNameDiscoverer.getParameterNames(method);
        String[] attributeNames = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            attributeNames[i] = WithSpanAspectAttributeBinder.attributeName(parameters[i], parameterNames, i);
        }
        return attributeNames;
    }

    private static @Nullable String attributeName(Parameter parameter, String[] parameterNames, int index) {
        String parameterName;
        SpanAttribute annotation = parameter.getDeclaredAnnotation(SpanAttribute.class);
        if (annotation == null) {
            return null;
        }
        String value = annotation.value();
        if (!value.isEmpty()) {
            return value;
        }
        if (parameterNames != null && index < parameterNames.length && (parameterName = parameterNames[index]) != null && !parameterName.isEmpty()) {
            return parameterName;
        }
        if (parameter.isNamePresent()) {
            return parameter.getName();
        }
        return null;
    }
}

