/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.aspects;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.extension.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import java.lang.reflect.Method;

class WithSpanAspectTracer
extends BaseTracer {
    WithSpanAspectTracer(OpenTelemetry openTelemetry) {
        super(openTelemetry);
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.spring-boot-autoconfigure-aspect";
    }

    Context startSpan(Context parentContext, WithSpan annotation, Method method) {
        Span span = this.spanBuilder(parentContext, this.spanName(annotation, method), annotation.kind()).startSpan();
        switch (annotation.kind()) {
            case SERVER: {
                return this.withServerSpan(parentContext, span);
            }
            case CLIENT: {
                return this.withClientSpan(parentContext, span);
            }
        }
        return parentContext.with((ImplicitContextKeyed)span);
    }

    private String spanName(WithSpan annotation, Method method) {
        String spanName = annotation.value();
        if (spanName.isEmpty()) {
            return WithSpanAspectTracer.spanNameForMethod((Method)method);
        }
        return spanName;
    }
}

