/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.instrumentation.spring.autoconfigure.TracerProperties;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TracerProperties.class})
public class TracerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Tracer otelTracer(TracerProvider tracerProvider, TracerProperties tracerProperties) {
        return tracerProvider.get(tracerProperties.getName());
    }

    @Bean
    @ConditionalOnMissingBean
    public TracerProvider tracerProvider(TracerProperties tracerProperties, ObjectProvider<List<SpanExporter>> spanExportersProvider) {
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder();
        ((List)spanExportersProvider.getIfAvailable(Collections::emptyList)).stream().map(SimpleSpanProcessor::create).forEach(arg_0 -> ((SdkTracerProviderBuilder)tracerProviderBuilder).addSpanProcessor(arg_0));
        SdkTracerProvider tracerProvider = tracerProviderBuilder.setSampler(Sampler.traceIdRatioBased((double)tracerProperties.getSamplerProbability())).build();
        OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).buildAndRegisterGlobal();
        return tracerProvider;
    }
}

