/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.webmvc;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.instrumentation.spring.autoconfigure.webmvc.WebMvcProperties;
import io.opentelemetry.instrumentation.spring.webmvc.WebMvcTracingFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@EnableConfigurationProperties(value={WebMvcProperties.class})
@ConditionalOnProperty(prefix="opentelemetry.trace.web", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={OncePerRequestFilter.class})
public class WebMvcFilterAutoConfiguration {
    @Bean
    public WebMvcTracingFilter otelWebMvcTracingFilter(Tracer tracer) {
        return new WebMvcTracingFilter(tracer);
    }
}

