/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.httpclients.webclient;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.instrumentation.spring.webflux.client.WebClientTracingFilter;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

final class WebClientBeanPostProcessor
implements BeanPostProcessor {
    private final Tracer tracer;

    WebClientBeanPostProcessor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof WebClient) {
            WebClient webClient = (WebClient)bean;
            return this.wrapBuilder(webClient.mutate()).build();
        }
        if (bean instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean;
            return this.wrapBuilder(webClientBuilder);
        }
        return bean;
    }

    private WebClient.Builder wrapBuilder(WebClient.Builder webClientBuilder) {
        return webClientBuilder.filters(this.webClientFilterFunctionConsumer());
    }

    private Consumer<List<ExchangeFilterFunction>> webClientFilterFunctionConsumer() {
        return functions -> {
            if (functions.stream().noneMatch(filter -> filter instanceof WebClientTracingFilter)) {
                WebClientTracingFilter.addFilter((List)functions);
            }
        };
    }
}

