/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.httpclients.resttemplate;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.instrumentation.spring.httpclients.RestTemplateInterceptor;
import java.util.List;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.client.RestTemplate;

final class RestTemplateBeanPostProcessor
implements BeanPostProcessor {
    private final Tracer tracer;

    public RestTemplateBeanPostProcessor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (!(bean instanceof RestTemplate)) {
            return bean;
        }
        RestTemplate restTemplate = (RestTemplate)bean;
        this.addRestTemplateInterceptorIfNotPresent(restTemplate);
        return restTemplate;
    }

    private void addRestTemplateInterceptorIfNotPresent(RestTemplate restTemplate) {
        List restTemplateInterceptors = restTemplate.getInterceptors();
        if (restTemplateInterceptors.stream().noneMatch(inteceptor -> inteceptor instanceof RestTemplateInterceptor)) {
            restTemplateInterceptors.add(0, new RestTemplateInterceptor(this.tracer));
        }
    }
}

