/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.instrumentation.spring.autoconfigure.TracerProperties;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TracerProperties.class})
public class TracerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Tracer otelTracer(TracerProperties tracerProperties, ObjectProvider<List<SpanExporter>> spanExportersProvider) throws Exception {
        Tracer tracer = OpenTelemetry.getGlobalTracer((String)tracerProperties.getName());
        List spanExporters = (List)spanExportersProvider.getIfAvailable();
        if (spanExporters == null || spanExporters.isEmpty()) {
            return tracer;
        }
        this.addSpanProcessors(spanExporters);
        this.setSampler(tracerProperties);
        return tracer;
    }

    private void addSpanProcessors(List<SpanExporter> spanExporters) {
        List spanProcessors = spanExporters.stream().map(spanExporter -> SimpleSpanProcessor.builder((SpanExporter)spanExporter).build()).collect(Collectors.toList());
        OpenTelemetrySdk.getGlobalTracerManagement().addSpanProcessor(SpanProcessor.composite(spanProcessors));
    }

    private void setSampler(TracerProperties tracerProperties) {
        TraceConfig updatedTraceConfig = OpenTelemetrySdk.getGlobalTracerManagement().getActiveTraceConfig().toBuilder().setSampler(Sampler.traceIdRatioBased((double)tracerProperties.getSamplerProbability())).build();
        OpenTelemetrySdk.getGlobalTracerManagement().updateActiveTraceConfig(updatedTraceConfig);
    }
}

