/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.resources.AttributeProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ResourceAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AttributeResourceProvider<D>
implements ConditionalResourceProvider {
    private final AttributeProvider<D> attributeProvider;
    private Set<AttributeKey<?>> filteredKeys;
    private final Map<AttributeKey<Object>, Function<D, Optional<?>>> attributeGetters = new HashMap();

    AttributeResourceProvider(AttributeProvider<D> attributeProvider) {
        this.attributeProvider = attributeProvider;
        attributeProvider.registerAttributes(new AttributeBuilder());
    }

    public final boolean shouldApply(ConfigProperties config, Resource existing) {
        Map resourceAttributes = config.getMap("otel.resource.attributes");
        this.filteredKeys = this.attributeGetters.keySet().stream().filter(key -> AttributeResourceProvider.shouldUpdate(config, existing, key, resourceAttributes)).collect(Collectors.toSet());
        return !this.filteredKeys.isEmpty();
    }

    public final Resource createResource(ConfigProperties config) {
        return this.attributeProvider.readData().map(data -> {
            if (this.filteredKeys == null) {
                throw new IllegalStateException("shouldApply should be called first");
            }
            AttributesBuilder builder = Attributes.builder();
            this.attributeGetters.entrySet().stream().filter(e -> this.filteredKeys.contains(e.getKey())).forEach(e -> ((Optional)((Function)e.getValue()).apply(data)).ifPresent(value -> AttributeResourceProvider.putAttribute(builder, (AttributeKey)e.getKey(), value)));
            return Resource.create((Attributes)builder.build());
        }).orElse(Resource.empty());
    }

    private static <T> void putAttribute(AttributesBuilder builder, AttributeKey<T> key, T value) {
        builder.put(key, value);
    }

    private static boolean shouldUpdate(ConfigProperties config, Resource existing, AttributeKey<?> key, Map<String, String> resourceAttributes) {
        if (resourceAttributes.containsKey(key.getKey())) {
            return false;
        }
        Object value = existing.getAttribute(key);
        if (key.equals((Object)ResourceAttributes.SERVICE_NAME)) {
            return config.getString("otel.service.name") == null && "unknown_service:java".equals(value);
        }
        return value == null;
    }

    public class AttributeBuilder
    implements AttributeProvider.Builder<D> {
        private AttributeBuilder() {
        }

        @CanIgnoreReturnValue
        public <T> AttributeBuilder add(AttributeKey<T> key, Function<D, Optional<T>> getter) {
            AttributeResourceProvider.this.attributeGetters.put(key, Objects.requireNonNull(getter));
            return this;
        }
    }
}

