/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import io.opentelemetry.instrumentation.resources.ContainerResource;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class CgroupV2ContainerIdExtractor {
    private static final Logger logger = Logger.getLogger(CgroupV2ContainerIdExtractor.class.getName());
    static final Path V2_CGROUP_PATH = Paths.get("/proc/self/mountinfo", new String[0]);
    private static final Pattern CONTAINER_ID_RE = Pattern.compile("^[0-9a-f]{64}$");
    private final ContainerResource.Filesystem filesystem;

    CgroupV2ContainerIdExtractor() {
        this(ContainerResource.FILESYSTEM_INSTANCE);
    }

    CgroupV2ContainerIdExtractor(ContainerResource.Filesystem filesystem) {
        this.filesystem = filesystem;
    }

    Optional<String> extractContainerId() {
        if (!this.filesystem.isReadable(V2_CGROUP_PATH)) {
            return Optional.empty();
        }
        try {
            return this.filesystem.lines(V2_CGROUP_PATH).filter(line -> line.contains("hostname")).flatMap(line -> Stream.of(line.split("/"))).map(CONTAINER_ID_RE::matcher).filter(Matcher::matches).findFirst().map(matcher -> matcher.group(0));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to read v2 cgroup path", e);
            return Optional.empty();
        }
    }
}

