/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.resources.ProcessArguments;
import io.opentelemetry.instrumentation.resources.ProcessPid;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;

public final class ProcessResource {
    private static final Pattern JAR_FILE_PATTERN = Pattern.compile("^\\S+\\.(jar|war)", 2);
    private static final Resource INSTANCE = ProcessResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource() {
        try {
            return ProcessResource.doBuildResource();
        }
        catch (LinkageError t) {
            return Resource.empty();
        }
    }

    private static Resource doBuildResource() {
        AttributesBuilder attributes = Attributes.builder();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        long pid = ProcessPid.getPid();
        if (pid >= 0L) {
            attributes.put(ResourceAttributes.PROCESS_PID, (Object)pid);
        }
        String javaHome = null;
        String osName = null;
        try {
            javaHome = System.getProperty("java.home");
            osName = System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (javaHome != null) {
            StringBuilder executablePath = new StringBuilder(javaHome);
            executablePath.append(File.separatorChar).append("bin").append(File.separatorChar).append("java");
            if (osName != null && osName.toLowerCase(Locale.ROOT).startsWith("windows")) {
                executablePath.append(".exe");
            }
            attributes.put(ResourceAttributes.PROCESS_EXECUTABLE_PATH, (Object)executablePath.toString());
            String[] args = ProcessArguments.getProcessArguments();
            if (args.length > 0) {
                ArrayList<String> commandArgs = new ArrayList<String>(args.length + 1);
                commandArgs.add(executablePath.toString());
                commandArgs.addAll(Arrays.asList(args));
                attributes.put(ResourceAttributes.PROCESS_COMMAND_ARGS, commandArgs);
            } else {
                StringBuilder commandLine = new StringBuilder(executablePath);
                for (String arg : runtime.getInputArguments()) {
                    commandLine.append(' ').append(arg);
                }
                String javaCommand = System.getProperty("sun.java.command");
                if (javaCommand != null) {
                    if (JAR_FILE_PATTERN.matcher(javaCommand).matches()) {
                        commandLine.append(" -jar");
                    }
                    commandLine.append(' ').append(javaCommand);
                }
                attributes.put(ResourceAttributes.PROCESS_COMMAND_LINE, (Object)commandLine.toString());
            }
        }
        return Resource.create((Attributes)attributes.build(), (String)"https://opentelemetry.io/schemas/1.19.0");
    }

    private ProcessResource() {
    }
}

