/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.instrumentation.resources.ProcessArguments;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@AutoService(value={ResourceProvider.class})
public final class JarServiceNameDetector
implements ConditionalResourceProvider {
    private static final Logger logger = Logger.getLogger(JarServiceNameDetector.class.getName());
    private final Supplier<String[]> getProcessHandleArguments;
    private final Function<String, String> getSystemProperty;
    private final Predicate<Path> fileExists;

    public JarServiceNameDetector() {
        this(ProcessArguments::getProcessArguments, System::getProperty, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    JarServiceNameDetector(Supplier<String[]> getProcessHandleArguments, Function<String, String> getSystemProperty, Predicate<Path> fileExists) {
        this.getProcessHandleArguments = getProcessHandleArguments;
        this.getSystemProperty = getSystemProperty;
        this.fileExists = fileExists;
    }

    public Resource createResource(ConfigProperties config) {
        Path jarPath = this.getJarPathFromProcessHandle();
        if (jarPath == null) {
            jarPath = this.getJarPathFromSunCommandLine();
        }
        if (jarPath == null) {
            return Resource.empty();
        }
        String serviceName = JarServiceNameDetector.getServiceName(jarPath);
        logger.log(Level.FINE, "Auto-detected service name from the jar file name: {0}", serviceName);
        return Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)serviceName));
    }

    public boolean shouldApply(ConfigProperties config, Resource existing) {
        String serviceName = config.getString("otel.service.name");
        Map resourceAttributes = config.getMap("otel.resource.attributes");
        return serviceName == null && !resourceAttributes.containsKey(ResourceAttributes.SERVICE_NAME.getKey()) && "unknown_service:java".equals(existing.getAttribute(ResourceAttributes.SERVICE_NAME));
    }

    @Nullable
    private Path getJarPathFromProcessHandle() {
        String[] javaArgs = this.getProcessHandleArguments.get();
        for (int i = 0; i < javaArgs.length; ++i) {
            if (!"-jar".equals(javaArgs[i]) || i >= javaArgs.length - 1) continue;
            return Paths.get(javaArgs[i + 1], new String[0]);
        }
        return null;
    }

    @Nullable
    private Path getJarPathFromSunCommandLine() {
        Path candidate;
        String programArguments = this.getSystemProperty.apply("sun.java.command");
        if (programArguments == null) {
            return null;
        }
        int next = 0;
        do {
            int nextSpace;
            if ((nextSpace = programArguments.indexOf(32, next)) == -1) {
                candidate = Paths.get(programArguments, new String[0]);
                return this.fileExists.test(candidate) ? candidate : null;
            }
            candidate = Paths.get(programArguments.substring(0, nextSpace), new String[0]);
            next = nextSpace + 1;
        } while (!this.fileExists.test(candidate));
        return candidate;
    }

    private static String getServiceName(Path jarPath) {
        String jarName = jarPath.getFileName().toString();
        int dotIndex = jarName.lastIndexOf(".");
        return dotIndex == -1 ? jarName : jarName.substring(0, dotIndex);
    }

    public int order() {
        return 1000;
    }
}

