/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.contextdata.v2_17;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.bootstrap.internal.ConfiguredResourceAttributesHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.util.ContextDataProvider;

public class OpenTelemetryContextDataProvider
implements ContextDataProvider {
    private static final boolean BAGGAGE_ENABLED = ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.log4j-context-data.add-baggage", (boolean)false);
    private static final String TRACE_ID_KEY = ConfigPropertiesUtil.getString((String)"otel.instrumentation.common.logging.trace-id", (String)"trace_id");
    private static final String SPAN_ID_KEY = ConfigPropertiesUtil.getString((String)"otel.instrumentation.common.logging.span-id", (String)"span_id");
    private static final String TRACE_FLAGS_KEY = ConfigPropertiesUtil.getString((String)"otel.instrumentation.common.logging.trace-flags", (String)"trace_flags");
    private static final boolean configuredResourceAttributeAccessible = OpenTelemetryContextDataProvider.isConfiguredResourceAttributeAccessible();
    private static final Map<String, String> staticContextData = OpenTelemetryContextDataProvider.getStaticContextData();

    private static Map<String, String> getStaticContextData() {
        if (configuredResourceAttributeAccessible) {
            return ConfiguredResourceAttributesHolder.getResourceAttributes();
        }
        return Collections.emptyMap();
    }

    private static boolean isConfiguredResourceAttributeAccessible() {
        try {
            Class.forName("io.opentelemetry.javaagent.bootstrap.internal.ConfiguredResourceAttributesHolder");
            return true;
        }
        catch (ClassNotFoundException ok) {
            return false;
        }
    }

    public Map<String, String> supplyContextData() {
        Context context = Context.current();
        Span currentSpan = Span.fromContext((Context)context);
        if (!currentSpan.getSpanContext().isValid()) {
            return staticContextData;
        }
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.putAll(staticContextData);
        SpanContext spanContext = currentSpan.getSpanContext();
        contextData.put(TRACE_ID_KEY, spanContext.getTraceId());
        contextData.put(SPAN_ID_KEY, spanContext.getSpanId());
        contextData.put(TRACE_FLAGS_KEY, spanContext.getTraceFlags().asHex());
        if (BAGGAGE_ENABLED) {
            Baggage baggage = Baggage.fromContext((Context)context);
            for (Map.Entry entry : baggage.asMap().entrySet()) {
                contextData.put("baggage." + (String)entry.getKey(), ((BaggageEntry)entry.getValue()).getValue());
            }
        }
        return contextData;
    }
}

