/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.contextdata.v2_17;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.util.ContextDataProvider;

public class OpenTelemetryContextDataProvider
implements ContextDataProvider {
    private static final boolean BAGGAGE_ENABLED = ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.log4j-context-data.add-baggage", (boolean)false);

    public Map<String, String> supplyContextData() {
        Context context = Context.current();
        Span currentSpan = Span.fromContext((Context)context);
        if (!currentSpan.getSpanContext().isValid()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> contextData = new HashMap<String, String>();
        SpanContext spanContext = currentSpan.getSpanContext();
        contextData.put("trace_id", spanContext.getTraceId());
        contextData.put("span_id", spanContext.getSpanId());
        contextData.put("trace_flags", spanContext.getTraceFlags().asHex());
        if (BAGGAGE_ENABLED) {
            Baggage baggage = Baggage.fromContext((Context)context);
            for (Map.Entry entry : baggage.asMap().entrySet()) {
                contextData.put("baggage." + (String)entry.getKey(), ((BaggageEntry)entry.getValue()).getValue());
            }
        }
        return contextData;
    }
}

