/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.kafka.common.TopicPartition;

enum KafkaReceiveAttributesGetter implements MessagingAttributesGetter<KafkaReceiveRequest, Void>
{
    INSTANCE;


    public String getSystem(KafkaReceiveRequest request) {
        return "kafka";
    }

    @Nullable
    public String getDestination(KafkaReceiveRequest request) {
        Set topics = request.getRecords().partitions().stream().map(TopicPartition::topic).collect(Collectors.toSet());
        return topics.size() == 1 ? (String)topics.iterator().next() : null;
    }

    @Nullable
    public String getDestinationTemplate(KafkaReceiveRequest request) {
        return null;
    }

    public boolean isTemporaryDestination(KafkaReceiveRequest request) {
        return false;
    }

    public boolean isAnonymousDestination(KafkaReceiveRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(KafkaReceiveRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageBodySize(KafkaReceiveRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageEnvelopeSize(KafkaReceiveRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(KafkaReceiveRequest request, @Nullable Void unused) {
        return null;
    }

    @Nullable
    public String getClientId(KafkaReceiveRequest request) {
        return request.getClientId();
    }

    public Long getBatchMessageCount(KafkaReceiveRequest request, @Nullable Void unused) {
        return request.getRecords().count();
    }

    public List<String> getMessageHeader(KafkaReceiveRequest request, String name) {
        return StreamSupport.stream(request.getRecords().spliterator(), false).flatMap(consumerRecord -> StreamSupport.stream(consumerRecord.headers().headers(name).spliterator(), false)).map(header -> new String(header.value(), StandardCharsets.UTF_8)).collect(Collectors.toList());
    }
}

