/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.util.VirtualField;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.MetricName;

public final class KafkaUtil {
    private static final String CONSUMER_GROUP = "consumer_group";
    private static final String CLIENT_ID = "client_id";
    private static final VirtualField<Consumer<?, ?>, Map<String, String>> consumerInfoField;
    private static final MethodHandle GET_GROUP_METADATA;
    private static final MethodHandle GET_GROUP_ID;

    @Nullable
    public static String getConsumerGroup(Consumer<?, ?> consumer) {
        return KafkaUtil.getConsumerInfo(consumer).get(CONSUMER_GROUP);
    }

    @Nullable
    public static String getClientId(Consumer<?, ?> consumer) {
        return KafkaUtil.getConsumerInfo(consumer).get(CLIENT_ID);
    }

    private static Map<String, String> getConsumerInfo(Consumer<?, ?> consumer) {
        if (consumer == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = (HashMap<String, String>)consumerInfoField.get(consumer);
        if (map == null) {
            map = new HashMap<String, String>();
            map.put(CONSUMER_GROUP, KafkaUtil.extractConsumerGroup(consumer));
            map.put(CLIENT_ID, KafkaUtil.extractClientId(consumer));
            consumerInfoField.set(consumer, map);
        }
        return map;
    }

    @Nullable
    private static String extractConsumerGroup(Consumer<?, ?> consumer) {
        if (GET_GROUP_METADATA == null || GET_GROUP_ID == null) {
            return null;
        }
        if (consumer == null) {
            return null;
        }
        try {
            Object metadata = GET_GROUP_METADATA.invoke(consumer);
            return GET_GROUP_ID.invoke(metadata);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    private static String extractClientId(Consumer<?, ?> consumer) {
        try {
            Map metrics = consumer.metrics();
            Iterator metricIterator = metrics.keySet().iterator();
            return metricIterator.hasNext() ? (String)((MetricName)metricIterator.next()).tags().get("client-id") : null;
        }
        catch (RuntimeException exception) {
            return null;
        }
    }

    private KafkaUtil() {
    }

    static {
        MethodHandle getGroupId;
        MethodHandle getGroupMetadata;
        consumerInfoField = VirtualField.find(Consumer.class, Map.class);
        try {
            Class<?> consumerGroupMetadata = Class.forName("org.apache.kafka.clients.consumer.ConsumerGroupMetadata");
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            getGroupMetadata = lookup.findVirtual(Consumer.class, "groupMetadata", MethodType.methodType(consumerGroupMetadata));
            getGroupId = lookup.findVirtual(consumerGroupMetadata, "groupId", MethodType.methodType(String.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ignored) {
            getGroupMetadata = null;
            getGroupId = null;
        }
        GET_GROUP_METADATA = getGroupMetadata;
        GET_GROUP_ID = getGroupId;
    }
}

