/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.kafka.internal.AbstractKafkaConsumerRequest;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafka.internal.KafkaUtil;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class KafkaReceiveRequest
extends AbstractKafkaConsumerRequest {
    private final ConsumerRecords<?, ?> records;

    public static KafkaReceiveRequest create(ConsumerRecords<?, ?> records, @Nullable Consumer<?, ?> consumer) {
        return KafkaReceiveRequest.create(records, KafkaUtil.getConsumerGroup(consumer), KafkaUtil.getClientId(consumer));
    }

    public static KafkaReceiveRequest create(KafkaConsumerContext consumerContext, ConsumerRecords<?, ?> records) {
        String consumerGroup = consumerContext != null ? consumerContext.getConsumerGroup() : null;
        String clientId = consumerContext != null ? consumerContext.getClientId() : null;
        return KafkaReceiveRequest.create(records, consumerGroup, clientId);
    }

    public static KafkaReceiveRequest create(ConsumerRecords<?, ?> records, String consumerGroup, String clientId) {
        return new KafkaReceiveRequest(records, consumerGroup, clientId);
    }

    private KafkaReceiveRequest(ConsumerRecords<?, ?> records, String consumerGroup, String clientId) {
        super(consumerGroup, clientId);
        this.records = records;
    }

    public ConsumerRecords<?, ?> getRecords() {
        return this.records;
    }
}

