/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProcessRequest;
import io.opentelemetry.semconv.incubating.MessagingIncubatingAttributes;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;

final class KafkaConsumerAttributesExtractor
implements AttributesExtractor<KafkaProcessRequest, Void> {
    KafkaConsumerAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, KafkaProcessRequest request) {
        String consumerGroup;
        ConsumerRecord<?, ?> record = request.getRecord();
        attributes.put(MessagingIncubatingAttributes.MESSAGING_DESTINATION_PARTITION_ID, (Object)String.valueOf(record.partition()));
        attributes.put(MessagingIncubatingAttributes.MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)record.offset());
        Object key = record.key();
        if (key != null && KafkaConsumerAttributesExtractor.canSerialize(key.getClass())) {
            attributes.put(MessagingIncubatingAttributes.MESSAGING_KAFKA_MESSAGE_KEY, (Object)key.toString());
        }
        if (record.value() == null) {
            attributes.put(MessagingIncubatingAttributes.MESSAGING_KAFKA_MESSAGE_TOMBSTONE, (Object)true);
        }
        if ((consumerGroup = request.getConsumerGroup()) != null) {
            attributes.put(MessagingIncubatingAttributes.MESSAGING_KAFKA_CONSUMER_GROUP, (Object)consumerGroup);
        }
    }

    private static boolean canSerialize(Class<?> keyClass) {
        return !keyClass.isArray() && keyClass != ByteBuffer.class;
    }

    public void onEnd(AttributesBuilder attributes, Context context, KafkaProcessRequest request, @Nullable Void unused, @Nullable Throwable error) {
    }
}

