/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import java.time.Instant;

public final class Timer {
    private final Instant startTime;
    private final long startNanoTime;

    public static Timer start() {
        return new Timer(Instant.now(), System.nanoTime());
    }

    private Timer(Instant startTime, long startNanoTime) {
        this.startTime = startTime;
        this.startNanoTime = startNanoTime;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant now() {
        long durationNanos = System.nanoTime() - this.startNanoTime;
        return this.startTime().plusNanos(durationNanos);
    }
}

