/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.config.ExperimentalConfig;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerAdditionalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerRecordGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerAdditionalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaPropagation;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.ReceivedRecords;
import java.util.Collections;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaInstrumenterFactory {
    public static Instrumenter<ProducerRecord<?, ?>, Void> createProducerInstrumenter(String instrumentationName) {
        return KafkaInstrumenterFactory.createProducerInstrumenter(instrumentationName, GlobalOpenTelemetry.get(), Collections.emptyList());
    }

    public static Instrumenter<ProducerRecord<?, ?>, Void> createProducerInstrumenter(String instrumentationName, OpenTelemetry openTelemetry, Iterable<AttributesExtractor<ProducerRecord<?, ?>, Void>> extractors) {
        KafkaProducerAttributesExtractor attributesExtractor = new KafkaProducerAttributesExtractor();
        SpanNameExtractor spanNameExtractor = MessagingSpanNameExtractor.create((MessagingAttributesExtractor)attributesExtractor);
        return Instrumenter.newBuilder((OpenTelemetry)openTelemetry, (String)instrumentationName, (SpanNameExtractor)spanNameExtractor).addAttributesExtractor((AttributesExtractor)attributesExtractor).addAttributesExtractors(extractors).addAttributesExtractor((AttributesExtractor)new KafkaProducerAdditionalAttributesExtractor()).newInstrumenter(SpanKindExtractor.alwaysProducer());
    }

    public static Instrumenter<ReceivedRecords, Void> createConsumerReceiveInstrumenter(String instrumentationName) {
        return KafkaInstrumenterFactory.createConsumerReceiveInstrumenter(instrumentationName, GlobalOpenTelemetry.get(), Collections.emptyList());
    }

    public static Instrumenter<ReceivedRecords, Void> createConsumerReceiveInstrumenter(String instrumentationName, OpenTelemetry openTelemetry, Iterable<AttributesExtractor<ReceivedRecords, Void>> extractors) {
        KafkaReceiveAttributesExtractor attributesExtractor = new KafkaReceiveAttributesExtractor();
        SpanNameExtractor spanNameExtractor = MessagingSpanNameExtractor.create((MessagingAttributesExtractor)attributesExtractor);
        return Instrumenter.newBuilder((OpenTelemetry)openTelemetry, (String)instrumentationName, (SpanNameExtractor)spanNameExtractor).addAttributesExtractor((AttributesExtractor)attributesExtractor).addAttributesExtractors(extractors).setTimeExtractors(ReceivedRecords::startTime, (request, response, error) -> request.now()).setDisabled(ExperimentalConfig.get().suppressMessagingReceiveSpans()).newInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    public static Instrumenter<ConsumerRecord<?, ?>, Void> createConsumerProcessInstrumenter(String instrumentationName) {
        return KafkaInstrumenterFactory.createConsumerOperationInstrumenter(instrumentationName, GlobalOpenTelemetry.get(), MessageOperation.PROCESS, Collections.emptyList());
    }

    public static Instrumenter<ConsumerRecord<?, ?>, Void> createConsumerOperationInstrumenter(String instrumentationName, OpenTelemetry openTelemetry, MessageOperation operation, Iterable<AttributesExtractor<ConsumerRecord<?, ?>, Void>> extractors) {
        KafkaConsumerAttributesExtractor attributesExtractor = new KafkaConsumerAttributesExtractor(operation);
        SpanNameExtractor spanNameExtractor = MessagingSpanNameExtractor.create((MessagingAttributesExtractor)attributesExtractor);
        InstrumenterBuilder builder = Instrumenter.newBuilder((OpenTelemetry)openTelemetry, (String)instrumentationName, (SpanNameExtractor)spanNameExtractor).addAttributesExtractor((AttributesExtractor)attributesExtractor).addAttributesExtractor((AttributesExtractor)new KafkaConsumerAdditionalAttributesExtractor()).addAttributesExtractors(extractors);
        if (KafkaConsumerExperimentalAttributesExtractor.isEnabled()) {
            builder.addAttributesExtractor((AttributesExtractor)new KafkaConsumerExperimentalAttributesExtractor());
        }
        if (!KafkaPropagation.isPropagationEnabled()) {
            return builder.newInstrumenter(SpanKindExtractor.alwaysConsumer());
        }
        if (ExperimentalConfig.get().suppressMessagingReceiveSpans()) {
            return builder.newConsumerInstrumenter((TextMapGetter)new KafkaConsumerRecordGetter());
        }
        builder.addSpanLinksExtractor(SpanLinksExtractor.fromUpstreamRequest((ContextPropagators)GlobalOpenTelemetry.getPropagators(), (TextMapGetter)new KafkaConsumerRecordGetter()));
        return builder.newInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    private KafkaInstrumenterFactory() {
    }
}

