/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.ReceivedRecords;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kafka.common.TopicPartition;

public final class KafkaReceiveAttributesExtractor
extends MessagingAttributesExtractor<ReceivedRecords, Void> {
    public MessageOperation operation() {
        return MessageOperation.RECEIVE;
    }

    protected String system(ReceivedRecords receivedRecords) {
        return "kafka";
    }

    protected String destinationKind(ReceivedRecords receivedRecords) {
        return "topic";
    }

    @Nullable
    protected String destination(ReceivedRecords receivedRecords) {
        Set topics = receivedRecords.records().partitions().stream().map(TopicPartition::topic).collect(Collectors.toSet());
        return topics.size() == 1 ? (String)topics.iterator().next() : null;
    }

    protected boolean temporaryDestination(ReceivedRecords receivedRecords) {
        return false;
    }

    @Nullable
    protected String protocol(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    protected String protocolVersion(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    protected String url(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    protected String conversationId(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    protected Long messagePayloadSize(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    protected Long messagePayloadCompressedSize(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    protected String messageId(ReceivedRecords receivedRecords, @Nullable Void unused) {
        return null;
    }
}

