/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public final class KafkaConsumerAttributesExtractor
extends MessagingAttributesExtractor<ConsumerRecord<?, ?>, Void> {
    private final MessageOperation messageOperation;

    public KafkaConsumerAttributesExtractor(MessageOperation messageOperation) {
        this.messageOperation = messageOperation;
    }

    public MessageOperation operation() {
        return this.messageOperation;
    }

    protected String system(ConsumerRecord<?, ?> consumerRecord) {
        return "kafka";
    }

    protected String destinationKind(ConsumerRecord<?, ?> consumerRecord) {
        return "topic";
    }

    protected String destination(ConsumerRecord<?, ?> consumerRecord) {
        return consumerRecord.topic();
    }

    protected boolean temporaryDestination(ConsumerRecord<?, ?> consumerRecord) {
        return false;
    }

    @Nullable
    protected String protocol(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    @Nullable
    protected String protocolVersion(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    @Nullable
    protected String url(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    @Nullable
    protected String conversationId(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    protected Long messagePayloadSize(ConsumerRecord<?, ?> consumerRecord) {
        return consumerRecord.serializedValueSize();
    }

    @Nullable
    protected Long messagePayloadCompressedSize(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    @Nullable
    protected String messageId(ConsumerRecord<?, ?> consumerRecord, @Nullable Void unused) {
        return null;
    }
}

