/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProcessRequest;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;

final class KafkaConsumerAttributesExtractor
implements AttributesExtractor<KafkaProcessRequest, Void> {
    KafkaConsumerAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, KafkaProcessRequest request) {
        String consumerId;
        String clientId;
        String consumerGroup;
        ConsumerRecord<?, ?> record = request.getRecord();
        attributes.put(SemanticAttributes.MESSAGING_KAFKA_SOURCE_PARTITION, (Object)record.partition());
        attributes.put(SemanticAttributes.MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)record.offset());
        Object key = record.key();
        if (key != null && KafkaConsumerAttributesExtractor.canSerialize(key.getClass())) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_MESSAGE_KEY, (Object)key.toString());
        }
        if (record.value() == null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_MESSAGE_TOMBSTONE, (Object)true);
        }
        if ((consumerGroup = request.getConsumerGroup()) != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_CONSUMER_GROUP, (Object)consumerGroup);
        }
        if ((clientId = request.getClientId()) != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_CLIENT_ID, (Object)clientId);
        }
        if ((consumerId = request.getConsumerId()) != null) {
            attributes.put(SemanticAttributes.MESSAGING_CONSUMER_ID, (Object)consumerId);
        }
    }

    private static boolean canSerialize(Class<?> keyClass) {
        return !keyClass.isArray() && keyClass != ByteBuffer.class;
    }

    public void onEnd(AttributesBuilder attributes, Context context, KafkaProcessRequest request, @Nullable Void unused, @Nullable Throwable error) {
    }
}

