/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveRequest;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

enum KafkaReceiveAttributesExtractor implements AttributesExtractor<KafkaReceiveRequest, Void>
{
    INSTANCE;


    public void onStart(AttributesBuilder attributes, Context parentContext, KafkaReceiveRequest request) {
        String consumerId;
        String clientId;
        String consumerGroup = request.getConsumerGroup();
        if (consumerGroup != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_CONSUMER_GROUP, (Object)consumerGroup);
        }
        if ((clientId = request.getClientId()) != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_CLIENT_ID, (Object)clientId);
        }
        if ((consumerId = request.getConsumerId()) != null) {
            attributes.put(SemanticAttributes.MESSAGING_CONSUMER_ID, (Object)consumerId);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, KafkaReceiveRequest request, @Nullable Void unused, @Nullable Throwable error) {
    }
}

