/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.RecordMetadata;

enum KafkaProducerAttributesGetter implements MessagingAttributesGetter<KafkaProducerRequest, RecordMetadata>
{
    INSTANCE;


    public String getSystem(KafkaProducerRequest request) {
        return "kafka";
    }

    public String getDestinationKind(KafkaProducerRequest request) {
        return "topic";
    }

    public String getDestination(KafkaProducerRequest request) {
        return request.getRecord().topic();
    }

    public boolean isTemporaryDestination(KafkaProducerRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(KafkaProducerRequest request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadSize(KafkaProducerRequest request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadCompressedSize(KafkaProducerRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(KafkaProducerRequest request, @Nullable RecordMetadata recordMetadata) {
        return null;
    }

    public List<String> getMessageHeader(KafkaProducerRequest request, String name) {
        return StreamSupport.stream(request.getRecord().headers().headers(name).spliterator(), false).map(header -> new String(header.value(), StandardCharsets.UTF_8)).collect(Collectors.toList());
    }
}

