/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerRequest;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.RecordMetadata;

final class KafkaProducerAttributesExtractor
implements AttributesExtractor<KafkaProducerRequest, RecordMetadata> {
    KafkaProducerAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, KafkaProducerRequest request) {
        Object key = request.getRecord().key();
        if (key != null && KafkaProducerAttributesExtractor.canSerialize(key.getClass())) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_MESSAGE_KEY, (Object)key.toString());
        }
        if (request.getRecord().value() == null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_MESSAGE_TOMBSTONE, (Object)true);
        }
        if (request.getClientId() != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_CLIENT_ID, (Object)request.getClientId());
        }
    }

    private static boolean canSerialize(Class<?> keyClass) {
        return !keyClass.isArray() && keyClass != ByteBuffer.class;
    }

    public void onEnd(AttributesBuilder attributes, Context context, KafkaProducerRequest request, @Nullable RecordMetadata recordMetadata, @Nullable Throwable error) {
        if (recordMetadata != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_DESTINATION_PARTITION, recordMetadata.partition());
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)recordMetadata.offset());
        }
    }
}

