/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public final class KafkaConsumerAdditionalAttributesExtractor
implements AttributesExtractor<ConsumerRecord<?, ?>, Void> {
    private static final AttributeKey<Long> MESSAGING_KAFKA_MESSAGE_OFFSET = AttributeKey.longKey((String)"messaging.kafka.message.offset");

    public void onStart(AttributesBuilder attributes, Context parentContext, ConsumerRecord<?, ?> consumerRecord) {
        attributes.put(SemanticAttributes.MESSAGING_KAFKA_PARTITION, (Object)consumerRecord.partition());
        attributes.put(MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)consumerRecord.offset());
        if (consumerRecord.value() == null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_TOMBSTONE, (Object)true);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, ConsumerRecord<?, ?> consumerRecord, @Nullable Void unused, @Nullable Throwable error) {
    }
}

