/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.ProducerRecord;

public enum KafkaProducerAttributesGetter implements MessagingAttributesGetter<ProducerRecord<?, ?>, Void>
{
    INSTANCE;


    public String system(ProducerRecord<?, ?> producerRecord) {
        return "kafka";
    }

    public String destinationKind(ProducerRecord<?, ?> producerRecord) {
        return "topic";
    }

    public String destination(ProducerRecord<?, ?> producerRecord) {
        return producerRecord.topic();
    }

    public boolean temporaryDestination(ProducerRecord<?, ?> producerRecord) {
        return false;
    }

    @Nullable
    public String protocol(ProducerRecord<?, ?> producerRecord) {
        return null;
    }

    @Nullable
    public String protocolVersion(ProducerRecord<?, ?> producerRecord) {
        return null;
    }

    @Nullable
    public String url(ProducerRecord<?, ?> producerRecord) {
        return null;
    }

    @Nullable
    public String conversationId(ProducerRecord<?, ?> producerRecord) {
        return null;
    }

    @Nullable
    public Long messagePayloadSize(ProducerRecord<?, ?> producerRecord) {
        return null;
    }

    @Nullable
    public Long messagePayloadCompressedSize(ProducerRecord<?, ?> producerRecord) {
        return null;
    }

    @Nullable
    public String messageId(ProducerRecord<?, ?> producerRecord, @Nullable Void unused) {
        return null;
    }

    public List<String> header(ProducerRecord<?, ?> producerRecord, String name) {
        return StreamSupport.stream(producerRecord.headers().headers(name).spliterator(), false).map(header -> new String(header.value(), StandardCharsets.UTF_8)).collect(Collectors.toList());
    }
}

