/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaProducerAdditionalAttributesExtractor
implements AttributesExtractor<ProducerRecord<?, ?>, Void> {
    public void onStart(AttributesBuilder attributes, Context parentContext, ProducerRecord<?, ?> producerRecord) {
        Integer partition = producerRecord.partition();
        if (partition != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_PARTITION, (Object)partition.longValue());
        }
        if (producerRecord.value() == null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_TOMBSTONE, (Object)true);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, ProducerRecord<?, ?> producerRecord, @Nullable Void unused, @Nullable Throwable error) {
    }
}

