/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.api.internal.PropagatorBasedSpanLinksExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaBatchProcessAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaBatchProcessSpanLinksExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerAdditionalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerRecordGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerAdditionalAttributesExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaReceiveAttributesGetter;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaInstrumenterFactory {
    private final OpenTelemetry openTelemetry;
    private final String instrumentationName;
    private ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.getDefault();
    private List<String> capturedHeaders = Collections.emptyList();
    private boolean captureExperimentalSpanAttributes = false;
    private boolean propagationEnabled = true;
    private boolean messagingReceiveInstrumentationEnabled = false;

    public KafkaInstrumenterFactory(OpenTelemetry openTelemetry, String instrumentationName) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
    }

    public KafkaInstrumenterFactory setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = errorCauseExtractor;
        return this;
    }

    public KafkaInstrumenterFactory setCapturedHeaders(List<String> capturedHeaders) {
        this.capturedHeaders = capturedHeaders;
        return this;
    }

    public KafkaInstrumenterFactory setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    public KafkaInstrumenterFactory setPropagationEnabled(boolean propagationEnabled) {
        this.propagationEnabled = propagationEnabled;
        return this;
    }

    public KafkaInstrumenterFactory setMessagingReceiveInstrumentationEnabled(boolean messagingReceiveInstrumentationEnabled) {
        this.messagingReceiveInstrumentationEnabled = messagingReceiveInstrumentationEnabled;
        return this;
    }

    public Instrumenter<ProducerRecord<?, ?>, Void> createProducerInstrumenter() {
        return this.createProducerInstrumenter(Collections.emptyList());
    }

    public Instrumenter<ProducerRecord<?, ?>, Void> createProducerInstrumenter(Iterable<AttributesExtractor<ProducerRecord<?, ?>, Void>> extractors) {
        KafkaProducerAttributesGetter getter = KafkaProducerAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.SEND;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor(KafkaInstrumenterFactory.buildMessagingAttributesExtractor(getter, operation, this.capturedHeaders)).addAttributesExtractors(extractors).addAttributesExtractor((AttributesExtractor)new KafkaProducerAdditionalAttributesExtractor()).setErrorCauseExtractor(this.errorCauseExtractor).buildInstrumenter(SpanKindExtractor.alwaysProducer());
    }

    public Instrumenter<ConsumerRecords<?, ?>, Void> createConsumerReceiveInstrumenter() {
        KafkaReceiveAttributesGetter getter = KafkaReceiveAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.RECEIVE;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor(KafkaInstrumenterFactory.buildMessagingAttributesExtractor(getter, operation, this.capturedHeaders)).setErrorCauseExtractor(this.errorCauseExtractor).setEnabled(this.messagingReceiveInstrumentationEnabled).buildInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    public Instrumenter<ConsumerRecord<?, ?>, Void> createConsumerProcessInstrumenter() {
        return this.createConsumerOperationInstrumenter(MessageOperation.PROCESS, Collections.emptyList());
    }

    public Instrumenter<ConsumerRecord<?, ?>, Void> createConsumerOperationInstrumenter(MessageOperation operation, Iterable<AttributesExtractor<ConsumerRecord<?, ?>, Void>> extractors) {
        KafkaConsumerAttributesGetter getter = KafkaConsumerAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor(KafkaInstrumenterFactory.buildMessagingAttributesExtractor(getter, operation, this.capturedHeaders)).addAttributesExtractor((AttributesExtractor)new KafkaConsumerAdditionalAttributesExtractor()).addAttributesExtractors(extractors).setErrorCauseExtractor(this.errorCauseExtractor);
        if (this.captureExperimentalSpanAttributes) {
            builder.addAttributesExtractor((AttributesExtractor)new KafkaConsumerExperimentalAttributesExtractor());
        }
        if (!this.propagationEnabled) {
            return builder.buildInstrumenter(SpanKindExtractor.alwaysConsumer());
        }
        if (this.messagingReceiveInstrumentationEnabled) {
            builder.addSpanLinksExtractor((SpanLinksExtractor)new PropagatorBasedSpanLinksExtractor(this.openTelemetry.getPropagators().getTextMapPropagator(), (TextMapGetter)KafkaConsumerRecordGetter.INSTANCE));
            return builder.buildInstrumenter(SpanKindExtractor.alwaysConsumer());
        }
        return builder.buildConsumerInstrumenter((TextMapGetter)KafkaConsumerRecordGetter.INSTANCE);
    }

    public Instrumenter<ConsumerRecords<?, ?>, Void> createBatchProcessInstrumenter() {
        KafkaBatchProcessAttributesGetter getter = KafkaBatchProcessAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.PROCESS;
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor(KafkaInstrumenterFactory.buildMessagingAttributesExtractor(getter, operation, this.capturedHeaders)).addSpanLinksExtractor((SpanLinksExtractor)new KafkaBatchProcessSpanLinksExtractor(this.openTelemetry.getPropagators().getTextMapPropagator())).setErrorCauseExtractor(this.errorCauseExtractor).buildInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    private static <T> MessagingAttributesExtractor<T, Void> buildMessagingAttributesExtractor(MessagingAttributesGetter<T, Void> getter, MessageOperation operation, List<String> capturedHeaders) {
        return MessagingAttributesExtractor.builder(getter, (MessageOperation)operation).setCapturedHeaders(capturedHeaders).build();
    }
}

