/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;

public final class KafkaConsumerExperimentalAttributesExtractor
implements AttributesExtractor<ConsumerRecord<?, ?>, Void> {
    private static final AttributeKey<Long> KAFKA_OFFSET = AttributeKey.longKey((String)"kafka.offset");
    private static final AttributeKey<Long> KAFKA_RECORD_QUEUE_TIME_MS = AttributeKey.longKey((String)"kafka.record.queue_time_ms");

    public void onStart(AttributesBuilder attributes, Context parentContext, ConsumerRecord<?, ?> consumerRecord) {
        attributes.put(KAFKA_OFFSET, (Object)consumerRecord.offset());
        if (consumerRecord.timestampType() != TimestampType.NO_TIMESTAMP_TYPE) {
            long produceTime = consumerRecord.timestamp();
            attributes.put(KAFKA_RECORD_QUEUE_TIME_MS, (Object)Math.max(0L, System.currentTimeMillis() - produceTime));
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, ConsumerRecord<?, ?> consumerRecord, @Nullable Void unused, @Nullable Throwable error) {
    }
}

