/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public enum KafkaConsumerAttributesGetter implements MessagingAttributesGetter<ConsumerRecord<?, ?>, Void>
{
    INSTANCE;


    public String system(ConsumerRecord<?, ?> consumerRecord) {
        return "kafka";
    }

    public String destinationKind(ConsumerRecord<?, ?> consumerRecord) {
        return "topic";
    }

    public String destination(ConsumerRecord<?, ?> consumerRecord) {
        return consumerRecord.topic();
    }

    public boolean temporaryDestination(ConsumerRecord<?, ?> consumerRecord) {
        return false;
    }

    @Nullable
    public String protocol(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    @Nullable
    public String protocolVersion(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    @Nullable
    public String url(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    @Nullable
    public String conversationId(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    public Long messagePayloadSize(ConsumerRecord<?, ?> consumerRecord) {
        return consumerRecord.serializedValueSize();
    }

    @Nullable
    public Long messagePayloadCompressedSize(ConsumerRecord<?, ?> consumerRecord) {
        return null;
    }

    @Nullable
    public String messageId(ConsumerRecord<?, ?> consumerRecord, @Nullable Void unused) {
        return null;
    }

    public List<String> header(ConsumerRecord<?, ?> consumerRecord, String name) {
        return StreamSupport.stream(consumerRecord.headers().headers(name).spliterator(), false).map(header -> new String(header.value(), StandardCharsets.UTF_8)).collect(Collectors.toList());
    }
}

